/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.UnitConverter;
import org.apache.sis.metadata.internal.shared.NameToIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ObjectFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public final class CoordinateOperations {
    public static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.operation");
    public static final String PARAMETERS_KEY = "parameters";
    public static final String OPERATION_TYPE_KEY = "operationType";
    public static final ThreadLocal<Supplier<double[]>> CONSTANT_COORDINATES = new ThreadLocal();
    private static final Set<Integer>[] CACHE = new Set[11];

    private CoordinateOperations() {
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory mtFactory, CRSFactory crsFactory, CSFactory csFactory) {
        if (Containers.isNullOrEmpty(properties)) {
            if (CoordinateOperations.isDefaultInstance(mtFactory) && CoordinateOperations.isDefaultInstance((ObjectFactory)crsFactory) && CoordinateOperations.isDefaultInstance((ObjectFactory)csFactory)) {
                return DefaultCoordinateOperationFactory.provider();
            }
            properties = Map.of();
        }
        HashMap p = new HashMap(properties);
        p.putIfAbsent("crsFactory", crsFactory);
        p.putIfAbsent("csFactory", csFactory);
        properties = p;
        return new DefaultCoordinateOperationFactory(properties, mtFactory);
    }

    public static OperationMethod getMethod(CoordinateOperation operation) {
        if (operation instanceof SingleOperation) {
            return ((SingleOperation)operation).getMethod();
        }
        return null;
    }

    public static OperationMethod findMethod(MathTransformFactory mtFactory, IdentifiedObject descriptor) throws NoSuchIdentifierException {
        OperationMethod method;
        String methodName = descriptor.getName().getCode();
        String methodIdentifier = IdentifiedObjects.toString(IdentifiedObjects.getIdentifier(descriptor, (Citation)Citations.EPSG));
        if (methodIdentifier == null) {
            methodIdentifier = methodName;
        }
        try {
            method = CoordinateOperations.findMethod(mtFactory, methodIdentifier);
        }
        catch (NoSuchIdentifierException exception) {
            if (methodIdentifier.equals(methodName)) {
                throw exception;
            }
            try {
                method = CoordinateOperations.findMethod(mtFactory, methodName);
            }
            catch (NoSuchIdentifierException e) {
                e.addSuppressed((Throwable)exception);
                throw e;
            }
            Logging.recoverableException((Logger)LOGGER, null, null, (Throwable)exception);
        }
        return method;
    }

    public static OperationMethod findMethod(MathTransformFactory mtFactory, String name) throws NoSuchIdentifierException {
        if (mtFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mtFactory).getOperationMethod(name);
        }
        return CoordinateOperations.findMethod(mtFactory.getAvailableMethods(SingleOperation.class), name);
    }

    public static OperationMethod findMethod(Iterable<? extends OperationMethod> methods, String identifier) throws NoSuchIdentifierException {
        OperationMethod fallback = null;
        for (OperationMethod operationMethod : methods) {
            if (!NameToIdentifier.isHeuristicMatchForName((IdentifiedObject)operationMethod, (String)identifier) && !NameToIdentifier.isHeuristicMatchForIdentifier((Iterable)operationMethod.getIdentifiers(), (String)identifier)) continue;
            if (!(operationMethod instanceof Deprecable) || !((Deprecable)operationMethod).isDeprecated()) {
                return operationMethod;
            }
            if (fallback != null) continue;
            fallback = operationMethod;
        }
        if (fallback != null) {
            return fallback;
        }
        throw new NoSuchIdentifierException(Resources.format((short)50, identifier, "https://sis.apache.org/tables/CoordinateOperationMethods.html"), identifier);
    }

    public static MathTransformBuilder builder(MathTransformFactory mtFactory, String method) throws NoSuchIdentifierException {
        if (mtFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mtFactory).builder(method);
        }
        OperationMethod m = CoordinateOperations.findMethod(mtFactory.getAvailableMethods(SingleOperation.class), method);
        return new ParameterizedTransformBuilder(mtFactory, m){

            @Override
            public MathTransform create() throws FactoryException {
                if (this.sourceCS == null && this.targetCS == null && this.sourceEllipsoid == null && this.targetEllipsoid == null) {
                    return this.swapAndScaleAxes(this.factory.createParameterizedTransform(this.parameters()));
                }
                return super.create();
            }
        };
    }

    public static boolean isDefaultInstance(MathTransformFactory mtFactory) {
        return mtFactory == DefaultMathTransformFactory.provider();
    }

    private static boolean isDefaultInstance(ObjectFactory factory) {
        return factory == GeodeticObjectFactory.provider();
    }

    public static boolean isWrapAround(CoordinateSystemAxis axis) {
        return axis.getRangeMeaning() == RangeMeaning.WRAPAROUND;
    }

    public static Set<Integer> wrapAroundChanges(CoordinateOperation op) {
        CoordinateReferenceSystem target;
        CoordinateReferenceSystem source;
        if (op instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)op).getWrapAroundChanges();
        }
        if (op != null && (source = op.getSourceCRS()) != null && (target = op.getTargetCRS()) != null) {
            return CoordinateOperations.wrapAroundChanges(source, target.getCoordinateSystem());
        }
        return Set.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<Integer> wrapAroundChanges(CoordinateReferenceSystem source, CoordinateSystem target) {
        Set<Integer> existing;
        boolean useCache;
        long changes = CoordinateOperations.changes(source.getCoordinateSystem(), target);
        while (source instanceof GeneralDerivedCRS) {
            source = ((GeneralDerivedCRS)source).getBaseCRS();
            changes |= CoordinateOperations.changes(source.getCoordinateSystem(), target);
        }
        boolean bl = useCache = changes >= 0L && changes < (long)CACHE.length;
        if (useCache && (existing = CACHE[(int)changes]) != null) {
            return existing;
        }
        long r = changes;
        Object[] indices = new Integer[Long.bitCount(r)];
        for (int i = 0; i < indices.length; ++i) {
            int dim = Long.numberOfTrailingZeros(r);
            indices[i] = dim;
            r &= 1L << dim ^ 0xFFFFFFFFFFFFFFFFL;
        }
        Set dimensions = CollectionsExt.immutableSet((boolean)true, (Object[])indices);
        if (!useCache) return dimensions;
        Set<Integer>[] setArray = CACHE;
        synchronized (CACHE) {
            Set<Integer> existing2 = CACHE[(int)changes];
            if (existing2 != null) {
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return existing2;
            }
            CoordinateOperations.CACHE[(int)changes] = dimensions;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return dimensions;
        }
    }

    private static long changes(CoordinateSystem source, CoordinateSystem target) {
        long changes = 0L;
        if (source != target) {
            long isWrapAroundAxis = (1 << source.getDimension()) - 1;
            int dim = Math.min(64, target.getDimension());
            block2: for (int i = 0; i < dim; ++i) {
                long mask;
                CoordinateSystemAxis axis = target.getAxis(i);
                if (!CoordinateOperations.isWrapAround(axis)) continue;
                long candidates = isWrapAroundAxis;
                do {
                    CoordinateSystemAxis src;
                    if (!AxisDirections.isColinear((src = source.getAxis(Long.numberOfTrailingZeros(mask = Long.lowestOneBit(candidates)))).getDirection(), axis.getDirection())) continue;
                    try {
                        UnitConverter c = src.getUnit().getConverterToAny(axis.getUnit());
                        double minimum = axis.getMinimumValue();
                        double maximum = axis.getMaximumValue();
                        double tolerance = (maximum - minimum) * 1.0E-13;
                        if (!Numerics.epsilonEqual((double)c.convert(src.getMinimumValue()), (double)minimum, (double)tolerance) || !Numerics.epsilonEqual((double)c.convert(src.getMaximumValue()), (double)maximum, (double)tolerance)) {
                            changes |= (long)(1 << i);
                        }
                        if ((isWrapAroundAxis &= mask ^ 0xFFFFFFFFFFFFFFFFL) != 0L) continue block2;
                        break block2;
                    }
                    catch (IncommensurableException incommensurableException) {
                        // empty catch block
                    }
                } while ((candidates &= mask ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            }
        }
        return changes;
    }
}

