/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.ResultSet;
import java.util.Locale;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.sql.feature.BinaryEncoding;
import org.apache.sis.storage.sql.feature.GeometryEncoding;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.ValueGetter;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GeometryGetter<G, V extends G>
extends ValueGetter<V> {
    private final Geometries<G> geometryFactory;
    private final CoordinateReferenceSystem defaultCRS;
    private final BinaryEncoding encoding;
    private final GeometryEncoding format;

    GeometryGetter(Geometries<G> geometryFactory, Class<V> geometryClass, CoordinateReferenceSystem defaultCRS, BinaryEncoding encoding, GeometryEncoding format) {
        super(geometryClass);
        this.geometryFactory = geometryFactory;
        this.defaultCRS = defaultCRS;
        this.encoding = encoding;
        this.format = format;
    }

    @Override
    public V getValue(InfoStatements stmts, ResultSet source, int columnIndex) throws Exception {
        GeometryWrapper geom;
        int gpkgSrid = 0;
        switch (this.format) {
            default: {
                return null;
            }
            case WKT: {
                String wkt = source.getString(columnIndex);
                if (wkt == null) {
                    return null;
                }
                geom = this.geometryFactory.parseWKT(wkt);
                break;
            }
            case WKB: {
                byte[] wkb = this.encoding.getBytes(source, columnIndex);
                if (wkb == null) {
                    return null;
                }
                ByteBuffer buffer = ByteBuffer.wrap(wkb);
                if (wkb.length > 8 && wkb[0] == 71 && wkb[1] == 80) {
                    int offset;
                    int version = Byte.toUnsignedInt(wkb[2]);
                    if (version != 0) {
                        throw new DataStoreContentException(Errors.forLocale((Locale)stmts.getLocale()).getString((short)195, (Object)"Geopackage", (Object)version));
                    }
                    byte flags = wkb[3];
                    boolean bigEndian = (flags & 1) == 0;
                    int envelopeType = (flags & 0xE) >> 1;
                    buffer.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                    gpkgSrid = buffer.getInt(4);
                    switch (envelopeType) {
                        case 0: {
                            offset = 8;
                            break;
                        }
                        case 1: {
                            offset = 40;
                            break;
                        }
                        case 2: 
                        case 3: {
                            offset = 56;
                            break;
                        }
                        case 4: {
                            offset = 72;
                            break;
                        }
                        default: {
                            throw new DataStoreContentException(Errors.forLocale((Locale)stmts.getLocale()).getString((short)176, (Object)"envelope contents indicator"));
                        }
                    }
                    buffer.position(offset).order(ByteOrder.BIG_ENDIAN);
                }
                geom = this.geometryFactory.parseWKB(buffer);
                break;
            }
        }
        CoordinateReferenceSystem crs = this.defaultCRS;
        if (stmts != null) {
            crs = stmts.fetchCRS(geom.getSRID().orElse(gpkgSrid));
        }
        if (crs != null) {
            geom.setCoordinateReferenceSystem(crs);
        }
        return (V)this.valueType.cast(this.geometryFactory.getGeometry(geom));
    }
}

