/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal.shared;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.sis.util.collection.CheckedContainer;

public class UnmodifiableArrayList<E>
extends AbstractList<E>
implements RandomAccess,
CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 13882164775184042L;
    final E[] array;

    protected UnmodifiableArrayList(E[] array) {
        this.array = Objects.requireNonNull(array);
    }

    public static <E> UnmodifiableArrayList<E> wrap(E[] array) {
        return array != null ? new UnmodifiableArrayList<E>(array) : null;
    }

    public static <E> UnmodifiableArrayList<E> wrap(E[] array, int lower, int upper) {
        if (lower == 0 && upper == array.length) {
            return new UnmodifiableArrayList<E>(array);
        }
        return new SubList<E>(array, lower, upper - lower);
    }

    @Override
    public Class<E> getElementType() {
        return this.array.getClass().getComponentType();
    }

    int lower() {
        return 0;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public final int arraySize() {
        return this.array.length;
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public int indexOf(Object object) {
        int lower = this.lower();
        int upper = lower + this.size();
        if (object == null) {
            for (int i = lower; i < upper; ++i) {
                if (this.array[i] != null) continue;
                return i - lower;
            }
        } else {
            for (int i = lower; i < upper; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i - lower;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int lower = this.lower();
        int i = lower + this.size();
        if (object == null) {
            while (--i >= lower && this.array[i] != null) {
            }
        } else {
            while (--i >= lower && !object.equals(this.array[i])) {
            }
        }
        return i - lower;
    }

    @Override
    public boolean contains(Object object) {
        int lower = this.lower();
        int i = lower + this.size();
        if (object == null) {
            while (--i >= lower) {
                if (this.array[i] != null) continue;
                return true;
            }
        } else {
            while (--i >= lower) {
                if (!object.equals(this.array[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public UnmodifiableArrayList<E> subList(int lower, int upper) throws IndexOutOfBoundsException {
        Objects.checkFromToIndex(lower, upper, this.size());
        return new SubList<E>(this.array, lower + this.lower(), upper - lower);
    }

    @Override
    public E[] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        int size = this.size();
        if (dest.length != size) {
            if (dest.length < size) {
                dest = (Object[])Array.newInstance(dest.getClass().getComponentType(), size);
            } else {
                dest[size] = null;
            }
        }
        System.arraycopy(this.array, this.lower(), dest, 0, size);
        return dest;
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            if (!(object instanceof UnmodifiableArrayList)) {
                return super.equals(object);
            }
            UnmodifiableArrayList that = (UnmodifiableArrayList)object;
            int size = this.size();
            if (size != that.size()) {
                return false;
            }
            int i = this.lower();
            int j = that.lower();
            while (--size >= 0) {
                if (Objects.equals(this.array[i++], that.array[j++])) continue;
                return false;
            }
        }
        return true;
    }

    private static final class SubList<E>
    extends UnmodifiableArrayList<E> {
        private static final long serialVersionUID = 33065197642139916L;
        private final int lower;
        private final int size;

        SubList(E[] array, int lower, int size) {
            super(array);
            this.lower = lower;
            this.size = size;
        }

        @Override
        int lower() {
            return this.lower;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public E get(int index) {
            return super.get(Objects.checkIndex(index, this.size) + this.lower);
        }

        @Override
        public E[] toArray() {
            return Arrays.copyOfRange(this.array, this.lower, this.lower + this.size);
        }
    }
}

