/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Text;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import org.apache.sling.ide.eclipse.core.internal.Activator;
import org.apache.sling.ide.eclipse.ui.nav.model.GenericJcrRootFile;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrTextPropertyDescriptor;
import org.apache.sling.ide.eclipse.ui.views.DateTimeSupport;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class ModifiableProperties
implements IPropertySource {
    private Map<String, String> properties = new HashMap<String, String>();
    private List<String> propertiesOrder = new LinkedList<String>();
    private JcrNode node;
    private Element domElement;
    private GenericJcrRootFile genericJcrRootFile;

    public ModifiableProperties(JcrNode node) {
        this.node = node;
    }

    public void setJcrNode(JcrNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        this.node = node;
    }

    public GenericJcrRootFile getUnderlying() {
        return this.genericJcrRootFile;
    }

    public Element getDomElement() {
        return this.domElement;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        HashMap<String, JcrTextPropertyDescriptor> conversionMap = new HashMap<String, JcrTextPropertyDescriptor>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            JcrTextPropertyDescriptor pd = new JcrTextPropertyDescriptor(entry, entry.getKey());
            conversionMap.put(entry.getKey(), pd);
        }
        LinkedList<String> propertiesOrderCopy = new LinkedList<String>(this.propertiesOrder);
        if (!this.properties.containsKey("jcr:primaryType")) {
            HashMap<String, String> pseudoMap = new HashMap<String, String>();
            pseudoMap.put("jcr:primaryType", this.node.getPrimaryType());
            JcrTextPropertyDescriptor pseudoPd = new JcrTextPropertyDescriptor(pseudoMap.entrySet().iterator().next(), "jcr:primaryType");
            propertiesOrderCopy.add(0, "jcr:primaryType");
            conversionMap.put("jcr:primaryType", pseudoPd);
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[conversionMap.size()];
        int i = 0;
        while (i < result.length) {
            String aPropertyName = (String)propertiesOrderCopy.get(i);
            result[i] = (IPropertyDescriptor)conversionMap.get(aPropertyName);
            ++i;
        }
        return result;
    }

    public String getValue(String key) {
        return this.properties.get(key);
    }

    public Object getPropertyValue(Object id) {
        Map.Entry entry = (Map.Entry)id;
        return entry.getValue();
    }

    public boolean isPropertySet(Object id) {
        return this.properties.containsKey(String.valueOf(id));
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String key;
        if (id instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)id;
            key = (String)entry.getKey();
        } else {
            key = String.valueOf(id);
        }
        if ("jcr:primaryType".equals(key)) {
            final String newPrimaryType = String.valueOf(value);
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ModifiableProperties.this.node.changePrimaryType(newPrimaryType);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(r, null);
            }
            catch (CoreException e) {
                Activator.getDefault().getPluginLogger().error("Error changing type to " + newPrimaryType + ": " + String.valueOf((Object)e), (Throwable)e);
                e.printStackTrace();
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error changing primary type", (String)("Error changing primary type to " + newPrimaryType + ": " + String.valueOf((Object)e)));
                return;
            }
            if (id instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)id;
                entry.setValue(String.valueOf(value));
            }
        } else {
            this.doSetPropertyValue(key, value);
        }
    }

    void doSetPropertyValue(Object id, Object value) {
        if (id instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)id;
            entry.setValue(String.valueOf(value));
            Attribute a = this.domElement.getAttribute((String)entry.getKey());
            a.setValue(String.valueOf(value));
            this.genericJcrRootFile.save();
        } else if (value instanceof String) {
            Attribute a = this.domElement.getAttribute((String)id);
            a.setValue((String)value);
            this.genericJcrRootFile.save();
        } else {
            System.out.println("UNSUPPORTED VALUE TYPE: " + String.valueOf(value.getClass()));
        }
    }

    public void setNode(GenericJcrRootFile genericJcrRootFile, Element domNode) {
        this.domElement = domNode;
        List attributes = domNode.getAttributes();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                String name = attribute.getName();
                if (name.startsWith("xmlns:")) continue;
                this.properties.put(name, attribute.getValue());
                this.propertiesOrder.add(name);
            }
        }
        this.genericJcrRootFile = genericJcrRootFile;
    }

    public void deleteProperty(String displayName) {
        this.domElement.removeAttribute(displayName);
        this.reformat();
        this.genericJcrRootFile.save();
    }

    public void addProperty(String name, String value) {
        this.domElement.addAttribute(name, value);
        this.reformat();
        this.genericJcrRootFile.save();
    }

    private void reformat() {
        List list = this.domElement.getAttributes();
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            Attribute first = (Attribute)list.get(0);
            first.setPreSpace("");
        } else {
            String correctPreSpace;
            String NL = System.getProperty("line.separator");
            Element parent = this.domElement.getParentElement();
            if (parent != null) {
                List nodes = parent.getNodes();
                if (nodes.size() > 1 && nodes.get(0) instanceof Text && ((Node)nodes.get(0)).toXML().startsWith(NL)) {
                    correctPreSpace = ((Node)nodes.get(0)).toXML() + "    ";
                } else {
                    Object totalIndent = "    ";
                    while (parent != null) {
                        totalIndent = (String)totalIndent + "    ";
                        parent = parent.getParentElement();
                    }
                    correctPreSpace = NL + (String)totalIndent;
                }
            } else {
                correctPreSpace = NL + "    ";
            }
            for (Attribute attribute : list) {
                if (attribute.getName().startsWith("xmlns:")) continue;
                attribute.setPreSpace(correctPreSpace);
            }
        }
    }

    public void renameProperty(String oldKey, String newKey) {
        Attribute a = this.domElement.getAttribute(oldKey);
        a.setName(newKey);
        this.genericJcrRootFile.save();
    }

    public void changePropertyType(String key, int propertyType) {
        Attribute a = this.domElement.getAttribute(key);
        Object value = a.getValue();
        switch (propertyType) {
            case 2: {
                value = "";
                break;
            }
            case 6: {
                try {
                    value = String.valueOf(Boolean.parseBoolean((String)value));
                }
                catch (Exception exception) {
                    value = "false";
                }
                break;
            }
            case 5: {
                try {
                    value = DateTimeSupport.print(DateTimeSupport.parseAsCalendar((String)value));
                }
                catch (Exception exception) {
                    value = DateTimeSupport.print(Calendar.getInstance());
                }
                break;
            }
            case 12: {
                try {
                    Float f = Float.valueOf(Float.parseFloat((String)value));
                    value = String.valueOf(f);
                }
                catch (Exception exception) {
                    value = "0.0";
                }
                break;
            }
            case 4: {
                try {
                    Double d = Double.parseDouble((String)value);
                    value = String.valueOf(d);
                }
                catch (Exception exception) {
                    value = "0.0";
                }
                break;
            }
            case 3: {
                try {
                    value = String.valueOf(Long.parseLong((String)value));
                }
                catch (Exception exception) {
                    value = "0";
                }
                break;
            }
            case 1: 
            case 7: {
                break;
            }
        }
        if (((String)value).startsWith("{") && ((String)value).contains("}")) {
            int index = ((String)value).indexOf("}");
            value = ((String)value).substring(index + 1);
        }
        if (propertyType != 1) {
            value = "{" + PropertyType.nameFromValue((int)propertyType) + "}" + (String)value;
        }
        a.setValue((String)value);
        this.genericJcrRootFile.save();
    }
}

