/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.ui.wizards.ConvertProjectsWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertToBundleProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IProject[] allProjects;
            LinkedList<IProject> applicableProjects = new LinkedList<IProject>();
            IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = allProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (p.isOpen() && ProjectHelper.isPotentialBundleProject((IProject)p)) {
                    applicableProjects.add(p);
                }
                ++n2;
            }
            Object[] elems = ((IStructuredSelection)selection).toArray();
            ArrayList<IProject> initialSelection = new ArrayList<IProject>(elems.length);
            Object[] objectArray = elems;
            int n3 = elems.length;
            int n4 = 0;
            while (n4 < n3) {
                Object elem = objectArray[n4];
                IProject project = null;
                if (elem instanceof IFile) {
                    IFile file = (IFile)elem;
                    project = file.getProject();
                } else if (elem instanceof IProject) {
                    project = (IProject)elem;
                } else if (elem instanceof IJavaProject) {
                    project = ((IJavaProject)elem).getProject();
                }
                if (project != null) {
                    initialSelection.add(project);
                }
                ++n4;
            }
            ConvertProjectsWizard wizard = new ConvertProjectsWizard(applicableProjects, initialSelection, "Convert to Bundle Project(s)", "Select project(s) to convert to Bundle project(s)\nList contains open Java projects that are not yet bundle or content projects.");
            Display display = this.getDisplay();
            final WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)wizard);
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() != 0) {
                return null;
            }
            final List<IProject> selectedProjects = wizard.getSelectedProjects();
            if (selectedProjects == null || selectedProjects.size() == 0) {
                return null;
            }
            IRunnableWithProgress r = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        for (IProject project : selectedProjects) {
                            ConfigurationHelper.convertToBundleProject((IProject)project);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)ConvertToBundleProjectHandler.this.getDisplay().getActiveShell(), (String)"Could not convert project", (String)e.getMessage());
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(r);
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)"Could not convert project", (String)e.getMessage());
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

