/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.serialization;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.transport.NodeTypeRegistry;
import org.apache.sling.ide.transport.Repository;
import org.apache.sling.ide.transport.RepositoryException;

public class SerializationKindManager {
    private final Set<String> fullMetadataNodeTypes = new HashSet<String>();
    private final Set<String> fileNodeTypes = new HashSet<String>();
    private final Set<String> folderNodeTypes = new HashSet<String>();

    public void init(Repository repository) throws RepositoryException {
        NodeTypeRegistry nodeTypeRegistry = repository.getNodeTypeRegistry();
        if (nodeTypeRegistry == null) {
            throw new IllegalStateException("nodeTypeRegistry must not be null here");
        }
        List<NodeType> nodeTypes = nodeTypeRegistry.getNodeTypes();
        for (NodeType nt : nodeTypes) {
            String nodeType = nt.getName();
            SerializationKind serializationKind = this.getSerializationKind(nodeType, nodeTypeRegistry);
            if (serializationKind == null) continue;
            switch (serializationKind) {
                case FILE: {
                    this.fileNodeTypes.add(nodeType);
                    break;
                }
                case FOLDER: {
                    this.folderNodeTypes.add(nodeType);
                    break;
                }
                case METADATA_FULL: {
                    this.fullMetadataNodeTypes.add(nodeType);
                }
            }
        }
    }

    private SerializationKind getSerializationKind(String nodeType, NodeTypeRegistry nodeTypeRegistry) {
        if ("nt:file".equals(nodeType)) {
            return SerializationKind.FILE;
        }
        if ("nt:resource".equals(nodeType)) {
            return SerializationKind.FILE;
        }
        if ("nt:folder".equals(nodeType)) {
            return SerializationKind.FOLDER;
        }
        if ("rep:accessControl".equals(nodeType) || "rep:Policy".equals(nodeType) || "cq:Widget".equals(nodeType) || "cq:EditConfig".equals(nodeType) || "cq:WorkflowModel".equals(nodeType) || "vlt:FullCoverage".equals(nodeType) || "mix:language".equals(nodeType) || "sling:OsgiConfig".equals(nodeType)) {
            return SerializationKind.METADATA_FULL;
        }
        String[] parents = nodeTypeRegistry.getNodeType(nodeType).getDeclaredSupertypeNames();
        if (parents == null) {
            return null;
        }
        for (String parent : parents) {
            SerializationKind parentSerializationKind = this.getSerializationKind(parent, nodeTypeRegistry);
            if (parentSerializationKind == null) continue;
            return parentSerializationKind;
        }
        return null;
    }

    public SerializationKind getSerializationKind(String nodeTypeName, List<String> mixinNodeTypeNames) {
        SerializationKind kind = null;
        for (String mixinNodeType : mixinNodeTypeNames) {
            kind = this.getSerializationKind0(mixinNodeType);
            if (kind == null) continue;
            return kind;
        }
        kind = this.getSerializationKind0(nodeTypeName);
        if (kind != null) {
            return kind;
        }
        return SerializationKind.METADATA_PARTIAL;
    }

    private SerializationKind getSerializationKind0(String nodeTypeName) {
        if (this.fullMetadataNodeTypes.contains(nodeTypeName)) {
            return SerializationKind.METADATA_FULL;
        }
        if (this.fileNodeTypes.contains(nodeTypeName)) {
            return SerializationKind.FILE;
        }
        if (this.folderNodeTypes.contains(nodeTypeName)) {
            return SerializationKind.FOLDER;
        }
        return null;
    }
}

