/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class SetUtils {
    private SetUtils() {
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        HashSet result = new HashSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <T> Set<T> toSet(@NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        HashSet result = new HashSet();
        iterator.forEachRemaining(result::add);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> toSet(T ... elements) {
        Objects.requireNonNull(elements);
        HashSet result = new HashSet(CollectionUtils.ensureCapacity(elements.length));
        Collections.addAll(result, elements);
        return result;
    }

    @NotNull
    public static <K> Set<K> newHashSet(int capacity) {
        return new HashSet(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    @NotNull
    public static <T> Set<T> toLinkedSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        LinkedHashSet result = new LinkedHashSet();
        iterable.forEach(result::add);
        return result;
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> toLinkedSet(T ... elements) {
        Objects.requireNonNull(elements);
        LinkedHashSet result = new LinkedHashSet(CollectionUtils.ensureCapacity(elements.length));
        Collections.addAll(result, elements);
        return result;
    }

    @NotNull
    public static <K> Set<K> newLinkedHashSet(int capacity) {
        return new LinkedHashSet(CollectionUtils.ensureCapacity(capacity));
    }

    @NotNull
    public static <T extends Comparable> TreeSet<T> toTreeSet(@NotNull Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable);
        TreeSet result = new TreeSet();
        iterable.forEach(result::add);
        return result;
    }

    @NotNull
    public static <K> Set<K> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    @NotNull
    public static <K> Set<K> newConcurrentHashSet(@NotNull Iterable<? extends K> elements) {
        Objects.requireNonNull(elements);
        Set<K> set = SetUtils.newConcurrentHashSet();
        elements.forEach(set::add);
        return set;
    }

    @NotNull
    public static <T> Set<T> union(@NotNull Set<T> s1, @NotNull Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return org.apache.commons.collections4.SetUtils.union(s1, s2);
    }

    @NotNull
    public static <T> Set<T> intersection(@NotNull Set<T> s1, @NotNull Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return org.apache.commons.collections4.SetUtils.intersection(s1, s2);
    }

    public static <T> Set<T> symmetricDifference(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return org.apache.commons.collections4.SetUtils.disjunction(s1, s2);
    }

    public static <T> Set<T> difference(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        return org.apache.commons.collections4.SetUtils.difference(s1, s2);
    }
}

