/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.commons.collections.IteratorUtils;
import org.jetbrains.annotations.NotNull;

public class StreamUtils {
    private StreamUtils() {
    }

    @NotNull
    public static <T> Stream<T> toStream(@NotNull Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NotNull
    public static <T> Stream<T> toStream(@NotNull Iterator<T> iterator) {
        return StreamSupport.stream(IteratorUtils.toIterable(iterator).spliterator(), false);
    }
}

