/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath;

import org.apache.jackrabbit.oak.namepath.JcrNameParser;

public final class JcrPathParser {
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;
    private static final int STATE_INDEX = 4;
    private static final int STATE_INDEX_END = 5;
    private static final int STATE_DOT = 6;
    private static final int STATE_DOTDOT = 7;
    private static final int STATE_URI = 8;
    private static final char EOF = '\uffff';

    private JcrPathParser() {
    }

    public static boolean parse(String jcrPath, Listener listener) {
        int len;
        int n = len = jcrPath == null ? 0 : jcrPath.length();
        if (len == 1 && jcrPath.charAt(0) == '/') {
            listener.root();
            return true;
        }
        if (len == 0) {
            return true;
        }
        int pos = 0;
        if (jcrPath.charAt(0) == '/') {
            if (!listener.root()) {
                return false;
            }
            ++pos;
        }
        int state = 0;
        int lastPos = pos;
        String name = null;
        int index = 0;
        boolean wasSlash = false;
        PathAwareListener pathAwareListener = new PathAwareListener(listener, jcrPath);
        while (pos <= len) {
            char c = pos == len ? (char)'\uffff' : (char)jcrPath.charAt(pos);
            ++pos;
            switch (c) {
                case '/': 
                case '\uffff': {
                    if (state == 0 && c != '\uffff') {
                        pathAwareListener.error("Double slash '//' not allowed.");
                        return false;
                    }
                    if (state == 1 || state == 3 || state == 5) {
                        if (name == null) {
                            if (wasSlash) {
                                pathAwareListener.error("Trailing slashes not allowed in prefixes and names.");
                                return false;
                            }
                            name = jcrPath.substring(lastPos, pos - 1);
                        }
                        if (!JcrNameParser.parse(name, pathAwareListener, index)) {
                            return false;
                        }
                        state = 0;
                        lastPos = pos;
                        name = null;
                        index = 0;
                        break;
                    }
                    if (state == 6) {
                        if (!pathAwareListener.current()) {
                            return false;
                        }
                        lastPos = pos;
                        state = 0;
                        break;
                    }
                    if (state == 7) {
                        if (!pathAwareListener.parent()) {
                            return false;
                        }
                        lastPos = pos;
                        state = 0;
                        break;
                    }
                    if (state == 2) {
                        pathAwareListener.error("Local name must not be empty.");
                        return false;
                    }
                    if (state == 8 && c == '\uffff') {
                        pathAwareListener.error("Missing '}'.");
                        return false;
                    }
                    if (state == 8 || state == 0 && c == 65535) break;
                    pathAwareListener.error("'" + c + "' not allowed in name.");
                    return false;
                }
                case '.': {
                    if (state == 0) {
                        state = 6;
                        break;
                    }
                    if (state == 6) {
                        state = 7;
                        break;
                    }
                    if (state == 7) {
                        state = 1;
                        break;
                    }
                    if (state != 5) break;
                    pathAwareListener.error("'" + c + "' not valid after index. '/' expected.");
                    return false;
                }
                case ':': {
                    if (state == 0) {
                        pathAwareListener.error("Prefix must not be empty.");
                        return false;
                    }
                    if (state == 1) {
                        if (wasSlash) {
                            pathAwareListener.error("Trailing slashes not allowed in prefixes and names.");
                            return false;
                        }
                        state = 2;
                        break;
                    }
                    if (state == 8) break;
                    pathAwareListener.error("'" + c + "' not allowed in name.");
                    return false;
                }
                case ']': {
                    if (state == 4) {
                        try {
                            index = Integer.parseInt(jcrPath.substring(lastPos, pos - 1));
                        }
                        catch (NumberFormatException e) {
                            pathAwareListener.error("NumberFormatException in index: " + jcrPath.substring(lastPos, pos - 1));
                            return false;
                        }
                        if (index < 0) {
                            pathAwareListener.error("Index number invalid: " + index);
                            return false;
                        }
                        state = 5;
                        break;
                    }
                    pathAwareListener.error("'" + c + "' not allowed in name.");
                    return false;
                }
                case '*': 
                case '|': {
                    pathAwareListener.error("'" + c + "' not allowed in name.");
                    return false;
                }
                case '{': {
                    if (state == 0 && lastPos == pos - 1) {
                        state = jcrPath.indexOf(125, pos) == -1 ? 3 : 8;
                        break;
                    }
                    if (state != 1 && state != 2 && state != 6 && state != 7) break;
                    state = 3;
                    break;
                }
                case '}': {
                    if (state == 8) {
                        state = jcrPath.indexOf(58, jcrPath.lastIndexOf(123, pos)) == -1 ? 3 : 2;
                        break;
                    }
                    if (state == 0 || state == 6 || state == 7) {
                        state = 1;
                        break;
                    }
                    if (state == 2 || state == 1) {
                        state = 3;
                        break;
                    }
                    if (state != 5) break;
                    pathAwareListener.error("'" + c + "' not valid after index. '/' expected.");
                    return false;
                }
                case '[': {
                    if (state == 1 || state == 3) {
                        if (wasSlash) {
                            pathAwareListener.error("Trailing slashes not allowed in prefixes and names.");
                            return false;
                        }
                        state = 4;
                        name = jcrPath.substring(lastPos, pos - 1);
                        lastPos = pos;
                        break;
                    }
                    if (state == 0 || state == 6 || state == 7) {
                        state = 1;
                        break;
                    }
                    if (state == 2) {
                        state = 3;
                        break;
                    }
                    if (state != 5) break;
                    pathAwareListener.error("'" + c + "' not valid after index. '/' expected.");
                    return false;
                }
                default: {
                    if (state == 0 || state == 6 || state == 7) {
                        state = 1;
                        break;
                    }
                    if (state == 2) {
                        state = 3;
                        break;
                    }
                    if (state != 5) break;
                    pathAwareListener.error("'" + c + "' not valid after index. '/' expected.");
                    return false;
                }
            }
            wasSlash = c == '/';
        }
        return true;
    }

    public static boolean validate(String jcrPath) {
        Listener listener = new Listener(){
            int depth;
            boolean hasRoot;

            @Override
            public boolean root() {
                if (this.hasRoot) {
                    return false;
                }
                this.hasRoot = true;
                return true;
            }

            @Override
            public boolean current() {
                return true;
            }

            @Override
            public boolean parent() {
                --this.depth;
                return !this.hasRoot || this.depth >= 0;
            }

            @Override
            public void error(String message) {
            }

            @Override
            public boolean name(String name, int index) {
                ++this.depth;
                return true;
            }
        };
        return JcrPathParser.parse(jcrPath, listener);
    }

    private static final class PathAwareListener
    implements Listener {
        private final Listener listener;
        private final String jcrPath;

        private PathAwareListener(Listener listener, String jcrPath) {
            this.listener = listener;
            this.jcrPath = jcrPath;
        }

        @Override
        public void error(String message) {
            this.listener.error("'" + this.jcrPath + "' is not a valid path. " + message);
        }

        @Override
        public boolean name(String name, int index) {
            return this.listener.name(name, index);
        }

        @Override
        public boolean root() {
            return this.listener.root();
        }

        @Override
        public boolean current() {
            return this.listener.current();
        }

        @Override
        public boolean parent() {
            return this.listener.parent();
        }
    }

    public static interface Listener
    extends JcrNameParser.Listener {
        public boolean root();

        public boolean current();

        public boolean parent();
    }
}

