/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.NodeTypeImpl;

class NodeDefinitionImpl
extends ItemDefinitionImpl
implements NodeDefinition {
    NodeDefinitionImpl(Tree definition, NodeType type, NamePathMapper mapper) {
        super(definition, type, mapper);
    }

    public String[] getRequiredPrimaryTypeNames() {
        String[] names = this.getNames("jcr:requiredPrimaryTypes");
        if (names == null) {
            names = new String[]{"nt:base"};
        }
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.mapper.getJcrName(names[i]);
        }
        return names;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        String[] oakNames = this.getNames("jcr:requiredPrimaryTypes");
        if (oakNames == null) {
            oakNames = new String[]{"nt:base"};
        }
        NodeType[] types = new NodeType[oakNames.length];
        Tree root = this.definition.getParent();
        while (!"jcr:nodeTypes".equals(root.getName())) {
            root = root.getParent();
        }
        for (int i = 0; i < oakNames.length; ++i) {
            Tree type = root.getChild(oakNames[i]);
            Validate.checkState(type.exists());
            types[i] = new NodeTypeImpl(type, this.mapper);
        }
        return types;
    }

    public String getDefaultPrimaryTypeName() {
        String oakName = this.getName("jcr:defaultPrimaryType");
        if (oakName != null) {
            return this.mapper.getJcrName(oakName);
        }
        return null;
    }

    public NodeType getDefaultPrimaryType() {
        String oakName = this.getName("jcr:defaultPrimaryType");
        if (oakName != null) {
            Tree types = this.definition.getParent();
            while (!"jcr:nodeTypes".equals(types.getName())) {
                types = types.getParent();
            }
            Tree type = types.getChild(oakName);
            Validate.checkState(type.exists());
            return new NodeTypeImpl(type, this.mapper);
        }
        return null;
    }

    public boolean allowsSameNameSiblings() {
        return this.getBoolean("jcr:sameNameSiblings");
    }
}

