/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.privilege.ImmutablePrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivilegeUtil
implements PrivilegeConstants {
    private PrivilegeUtil() {
    }

    @NotNull
    public static Tree getPrivilegesTree(@NotNull Root root) {
        return root.getTree("/jcr:system/rep:privileges");
    }

    @NotNull
    public static PrivilegeDefinition readDefinition(@NotNull Tree definitionTree) {
        String name = definitionTree.getName();
        boolean isAbstract = TreeUtil.getBoolean(definitionTree, "rep:isAbstract");
        Iterable<String> declAggrNames = null;
        PropertyState property = definitionTree.getProperty("rep:aggregates");
        if (property != null) {
            declAggrNames = property.getValue(Type.NAMES);
        }
        return new ImmutablePrivilegeDefinition(name, isAbstract, declAggrNames);
    }

    @NotNull
    public static Set<String> getOakNames(@Nullable String[] jcrNames, @NotNull NamePathMapper namePathMapper) throws AccessControlException {
        Set<String> oakNames;
        if (jcrNames == null || jcrNames.length == 0) {
            oakNames = Collections.emptySet();
        } else {
            oakNames = new HashSet<String>(jcrNames.length);
            for (String jcrName : jcrNames) {
                String oakName = PrivilegeUtil.getOakName(jcrName, namePathMapper);
                oakNames.add(oakName);
            }
        }
        return oakNames;
    }

    @NotNull
    public static String getOakName(@Nullable String jcrName, @NotNull NamePathMapper namePathMapper) throws AccessControlException {
        if (jcrName == null) {
            throw new AccessControlException("Invalid privilege name 'null'");
        }
        String oakName = namePathMapper.getOakNameOrNull(jcrName);
        if (oakName == null) {
            throw new AccessControlException("Cannot resolve privilege name " + jcrName);
        }
        return oakName;
    }
}

