/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit4.statements;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestContextManager;

public class RunAfterTestExecutionCallbacks
extends Statement {
    private final Statement next;
    private final Object testInstance;
    private final Method testMethod;
    private final TestContextManager testContextManager;

    public RunAfterTestExecutionCallbacks(Statement next, Object testInstance, Method testMethod, TestContextManager testContextManager) {
        this.next = next;
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testContextManager = testContextManager;
    }

    public void evaluate() throws Throwable {
        Throwable testException = null;
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.next.evaluate();
        }
        catch (Throwable ex) {
            testException = ex;
            errors.add(ex);
        }
        try {
            this.testContextManager.afterTestExecution(this.testInstance, this.testMethod, testException);
        }
        catch (Throwable ex) {
            errors.add(ex);
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

