/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.container.initialization.AbstractContainerInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;

public class ComponentDiscoveryPhase
extends AbstractContainerInitializationPhase {
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        try {
            ComponentDiscoveryPhase.discoverComponents(context.getContainer());
        }
        catch (PlexusConfigurationException e) {
            throw new ContainerInitializationException("Error discovering components.", e);
        }
        catch (ComponentRepositoryException e) {
            throw new ContainerInitializationException("Error discovering components.", e);
        }
    }

    public static List discoverComponents(DefaultPlexusContainer container) throws PlexusConfigurationException, ComponentRepositoryException {
        ArrayList<ComponentDescriptor> discoveredComponentDescriptors = new ArrayList<ComponentDescriptor>();
        Iterator i = container.getComponentDiscovererManager().getComponentDiscoverers().iterator();
        while (i.hasNext()) {
            ComponentDiscoverer componentDiscoverer = (ComponentDiscoverer)i.next();
            List componentSetDescriptors = componentDiscoverer.findComponents(container.getContext(), container.getContainerRealm());
            Iterator j = componentSetDescriptors.iterator();
            while (j.hasNext()) {
                ComponentSetDescriptor componentSet = (ComponentSetDescriptor)j.next();
                List componentDescriptors = componentSet.getComponents();
                if (componentDescriptors == null) continue;
                Iterator k = componentDescriptors.iterator();
                while (k.hasNext()) {
                    ComponentDescriptor componentDescriptor = (ComponentDescriptor)k.next();
                    componentDescriptor.setComponentSetDescriptor(componentSet);
                    if (container.getComponentDescriptor(componentDescriptor.getComponentKey()) != null) continue;
                    container.addComponentDescriptor(componentDescriptor);
                    discoveredComponentDescriptors.add(componentDescriptor);
                }
            }
        }
        return discoveredComponentDescriptors;
    }
}

