/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.core.definition.dao;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tiles.api.Definition;
import org.apache.tiles.core.definition.NoSuchDefinitionException;
import org.apache.tiles.core.definition.dao.CachingLocaleUrlDefinitionDAO;
import org.apache.tiles.request.ApplicationContext;

public class ResolvingLocaleUrlDefinitionDAO
extends CachingLocaleUrlDefinitionDAO {
    private static final Logger LOG = LogManager.getLogger(ResolvingLocaleUrlDefinitionDAO.class);

    public ResolvingLocaleUrlDefinitionDAO(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    protected Map<String, Definition> loadParentDefinitions(Locale parentLocale) {
        return this.loadRawDefinitionsFromResources(parentLocale);
    }

    @Override
    protected Map<String, Definition> loadDefinitions(Locale customizationKey) {
        Map<String, Definition> localeDefsMap = super.loadDefinitions(customizationKey);
        Map<String, Definition> defsMap = this.definitionResolver.storeDefinitionPatterns(this.copyDefinitionMap(localeDefsMap), customizationKey);
        this.resolveInheritances(defsMap, customizationKey);
        this.locale2definitionMap.put(customizationKey, defsMap);
        return defsMap;
    }

    @Override
    protected Definition getDefinitionFromResolver(String name, Locale customizationKey) {
        Definition retValue = super.getDefinitionFromResolver(name, customizationKey);
        if (retValue != null && retValue.getExtends() != null) {
            Definition parent = this.getDefinition(retValue.getExtends(), customizationKey);
            retValue.inherit(parent);
        }
        return retValue;
    }

    protected void resolveInheritances(Map<String, Definition> map, Locale locale) {
        if (map != null) {
            HashSet<String> alreadyResolvedDefinitions = new HashSet<String>();
            for (Definition definition : map.values()) {
                this.resolveInheritance(definition, map, locale, alreadyResolvedDefinitions);
            }
        }
    }

    protected void resolveInheritance(Definition definition, Map<String, Definition> definitions, Locale locale, Set<String> alreadyResolvedDefinitions) {
        if (!definition.isExtending() || alreadyResolvedDefinitions.contains(definition.getName())) {
            return;
        }
        LOG.debug("Resolve definition for child name='{}' extends='{}.", (Object)definition.getName(), (Object)definition.getExtends());
        alreadyResolvedDefinitions.add(definition.getName());
        Definition parent = definitions.get(definition.getExtends());
        if (parent == null) {
            String msg = "Error while resolving definition inheritance: child '" + definition.getName() + "' can't find its ancestor '" + definition.getExtends() + "'. Please check your description file.";
            throw new NoSuchDefinitionException(msg);
        }
        this.resolveInheritance(parent, definitions, locale, alreadyResolvedDefinitions);
        definition.inherit(parent);
    }

    @Override
    protected Map<String, Definition> copyDefinitionMap(Map<String, Definition> localeDefsMap) {
        LinkedHashMap<String, Definition> retValue = new LinkedHashMap<String, Definition>(localeDefsMap.size());
        for (Map.Entry<String, Definition> entry : localeDefsMap.entrySet()) {
            Definition definition = new Definition(entry.getValue());
            retValue.put(entry.getKey(), definition);
        }
        return retValue;
    }
}

