/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemoryJavaFileObject
extends SimpleJavaFileObject {
    private ByteArrayOutputStream out;

    public MemoryJavaFileObject(String name, JavaFileObject.Kind kind) {
        super(MemoryJavaFileObject.toURI(name), kind);
    }

    @Override
    public InputStream openInputStream() throws IOException, IllegalStateException, UnsupportedOperationException {
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    @Override
    public OutputStream openOutputStream() throws IOException, IllegalStateException, UnsupportedOperationException {
        this.out = new ByteArrayOutputStream();
        return this.out;
    }

    private static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }
}

