/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.oval.Validator;

public class ConcurrentMultiValueMap<K, V> {
    private static final Set<?> EMPTY_SET = Collections.unmodifiableSet(new HashSet());
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Map<K, Set<V>> map = Validator.getCollectionFactory().createMap();

    public static <K, V> ConcurrentMultiValueMap<K, V> create() {
        return new ConcurrentMultiValueMap<K, V>();
    }

    public boolean add(K key, V value) {
        this.rwLock.writeLock().lock();
        try {
            Set<V> set = this.map.get(key);
            if (set == null) {
                set = new LinkedHashSet<V>();
                this.map.put(key, set);
            }
            boolean bl = set.add(value);
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void addAllTo(K key, Collection<V> coll) {
        this.rwLock.readLock().lock();
        try {
            Set<V> set = this.map.get(key);
            if (set == null) {
                return;
            }
            coll.addAll(set);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean containsKey(K key) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean containsValue(K key, V value) {
        this.rwLock.readLock().lock();
        try {
            Set<V> set = this.map.get(key);
            if (set == null) {
                return false;
            }
            boolean bl = set.contains(value);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Iterable<V> get(K key) {
        this.rwLock.readLock().lock();
        try {
            Set<V> set = this.map.get(key);
            if (set == null) {
                Set<?> set2 = EMPTY_SET;
                return set2;
            }
            LinkedHashSet<V> linkedHashSet = new LinkedHashSet<V>(set);
            return linkedHashSet;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean remove(K key, V value) {
        this.rwLock.writeLock().lock();
        try {
            Set<V> set = this.map.get(key);
            if (set == null) {
                return false;
            }
            boolean removed = set.remove(value);
            if (set.isEmpty()) {
                this.map.remove(key);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

