/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.TokenTag;
import opennlp.tools.util.model.BaseModel;

public class ChunkerModel
extends BaseModel {
    private static final long serialVersionUID = 1608653769616498232L;
    private static final String COMPONENT_NAME = "ChunkerME";
    private static final String CHUNKER_MODEL_ENTRY_NAME = "chunker.model";

    public ChunkerModel(String languageCode, SequenceClassificationModel<String> chunkerModel, Map<String, String> manifestInfoEntries, ChunkerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, factory);
        this.artifactMap.put(CHUNKER_MODEL_ENTRY_NAME, chunkerModel);
        this.checkArtifactMap();
    }

    public ChunkerModel(String languageCode, MaxentModel chunkerModel, Map<String, String> manifestInfoEntries, ChunkerFactory factory) {
        this(languageCode, chunkerModel, 10, manifestInfoEntries, factory);
    }

    public ChunkerModel(String languageCode, MaxentModel chunkerModel, int beamSize, Map<String, String> manifestInfoEntries, ChunkerFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, factory);
        this.artifactMap.put(CHUNKER_MODEL_ENTRY_NAME, chunkerModel);
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        manifest.put("BeamSize", Integer.toString(beamSize));
        this.checkArtifactMap();
    }

    public ChunkerModel(String languageCode, MaxentModel chunkerModel, ChunkerFactory factory) {
        this(languageCode, chunkerModel, null, factory);
    }

    public ChunkerModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public ChunkerModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public ChunkerModel(Path modelPath) throws IOException {
        this(modelPath.toFile());
    }

    public ChunkerModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Chunker model is incomplete!");
        }
        if (this.getManifestProperty("factory") != null && !this.getManifestProperty("factory").equals("opennlp.tools.chunker.ChunkerFactory") && this.getVersion().getMajor() <= 1 && this.getVersion().getMinor() < 8) {
            throw new InvalidFormatException("The Chunker factory '" + this.getManifestProperty("factory") + "' is no longer compatible. Please update it to match the latest ChunkerFactory.");
        }
    }

    @Deprecated
    public MaxentModel getChunkerModel() {
        if (this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            return (MaxentModel)this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME);
        }
        return null;
    }

    public SequenceClassificationModel<TokenTag> getChunkerSequenceModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        if (this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof MaxentModel) {
            String beamSizeString = manifest.getProperty("BeamSize");
            int beamSize = 10;
            if (beamSizeString != null) {
                beamSize = Integer.parseInt(beamSizeString);
            }
            return new BeamSearch<TokenTag>(beamSize, (MaxentModel)this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME));
        }
        if (this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof SequenceClassificationModel) {
            return (SequenceClassificationModel)this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME);
        }
        return null;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return ChunkerFactory.class;
    }

    public ChunkerFactory getFactory() {
        return (ChunkerFactory)this.toolFactory;
    }
}

