/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorEvaluationMonitor;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.Mean;

public class LanguageDetectorEvaluator
extends Evaluator<LanguageSample> {
    private final LanguageDetector languageDetector;
    private final Mean accuracy = new Mean();

    public LanguageDetectorEvaluator(LanguageDetector langDetect, LanguageDetectorEvaluationMonitor ... listeners) {
        super(listeners);
        this.languageDetector = langDetect;
    }

    @Override
    public LanguageSample processSample(LanguageSample sample) {
        CharSequence document = sample.getContext();
        Language predicted = this.languageDetector.predictLanguage(document);
        if (sample.getLanguage().getLang().equals(predicted.getLang())) {
            this.accuracy.add(1.0);
        } else {
            this.accuracy.add(0.0);
        }
        return new LanguageSample(predicted, sample.getContext());
    }

    public double getAccuracy() {
        return this.accuracy.mean();
    }

    public long getDocumentCount() {
        return this.accuracy.count();
    }

    public String toString() {
        return "Accuracy: " + this.accuracy.mean() + "\nNumber of documents: " + this.accuracy.count();
    }
}

