/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;
import opennlp.tools.util.model.ModelUtil;

public final class TokenizerModel
extends BaseModel {
    private static final long serialVersionUID = 42334333400920419L;
    private static final String COMPONENT_NAME = "TokenizerME";
    private static final String TOKENIZER_MODEL_ENTRY = "token.model";

    public TokenizerModel(MaxentModel tokenizerModel, Map<String, String> manifestInfoEntries, TokenizerFactory tokenizerFactory) {
        super(COMPONENT_NAME, tokenizerFactory.getLanguageCode(), manifestInfoEntries, tokenizerFactory);
        this.artifactMap.put(TOKENIZER_MODEL_ENTRY, tokenizerModel);
        this.checkArtifactMap();
    }

    public TokenizerModel(InputStream in) throws IOException {
        super(COMPONENT_NAME, in);
    }

    public TokenizerModel(File modelFile) throws IOException {
        super(COMPONENT_NAME, modelFile);
    }

    public TokenizerModel(Path modelPath) throws IOException {
        this(modelPath.toFile());
    }

    public TokenizerModel(URL modelURL) throws IOException {
        super(COMPONENT_NAME, modelURL);
    }

    private static boolean isModelCompatible(MaxentModel model) {
        return ModelUtil.validateOutcomes(model, "T", "F");
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(TOKENIZER_MODEL_ENTRY) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token model is incomplete!");
        }
        if (!TokenizerModel.isModelCompatible(this.getMaxentModel())) {
            throw new InvalidFormatException("The maxent model is not compatible with the tokenizer!");
        }
    }

    public TokenizerFactory getFactory() {
        return (TokenizerFactory)this.toolFactory;
    }

    @Override
    protected Class<? extends BaseToolFactory> getDefaultFactory() {
        return TokenizerFactory.class;
    }

    public MaxentModel getMaxentModel() {
        return (MaxentModel)this.artifactMap.get(TOKENIZER_MODEL_ENTRY);
    }

    public Dictionary getAbbreviations() {
        if (this.getFactory() != null) {
            return this.getFactory().getAbbreviationDictionary();
        }
        return null;
    }

    public boolean useAlphaNumericOptimization() {
        return this.getFactory() != null && this.getFactory().isUseAlphaNumericOptimization();
    }

    public int hashCode() {
        return Objects.hash(this.artifactMap.get("manifest.properties"), this.artifactMap.get(TOKENIZER_MODEL_ENTRY));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TokenizerModel) {
            TokenizerModel model = (TokenizerModel)obj;
            Map artifactMapToCheck = model.artifactMap;
            AbstractModel abstractModel = (AbstractModel)artifactMapToCheck.get(TOKENIZER_MODEL_ENTRY);
            return this.artifactMap.get("manifest.properties").equals(artifactMapToCheck.get("manifest.properties")) && this.artifactMap.get(TOKENIZER_MODEL_ENTRY).equals(abstractModel);
        }
        return false;
    }
}

