/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.langid;

import java.util.List;
import org.apache.tika.eval.core.textstats.StringStatsCalculator;
import org.apache.tika.langdetect.opennlp.OpenNLPDetector;
import org.apache.tika.language.detect.LanguageResult;

public class LanguageIDWrapper
implements StringStatsCalculator<List<LanguageResult>> {
    static int MAX_TEXT_LENGTH = 50000;

    public static void setMaxTextLength(int maxContentLengthForLangId) {
        MAX_TEXT_LENGTH = maxContentLengthForLangId;
    }

    @Override
    public List<LanguageResult> calculate(String txt) {
        OpenNLPDetector detector = new OpenNLPDetector();
        detector.setMaxLength(MAX_TEXT_LENGTH);
        detector.addText(txt);
        return detector.detectAll();
    }

    public String[] getSupportedLanguages() {
        return new OpenNLPDetector().getSupportedLanguages();
    }
}

