/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.CoverageAggregator;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

final class GroupAggregate
extends AbstractResource
implements Aggregate,
AggregatedResource {
    private static final int KEEP_ALIVE = 2;
    private GenericName identifier;
    private String name;
    private final Resource[] components;
    private boolean componentsAreLeaves;
    private ImmutableEnvelope envelope;
    private boolean envelopeIsEvaluated;
    List<SampleDimension> sampleDimensions;

    GroupAggregate(StoreListeners listeners, String name, int count) {
        super(listeners, count < 2);
        this.components = new Resource[count];
        this.name = name;
    }

    GroupAggregate(StoreListeners listeners, String name, GridCoverageResource[] components, List<SampleDimension> sampleDimensions) {
        super(listeners, true);
        this.name = name;
        this.components = components;
        this.componentsAreLeaves = true;
        this.sampleDimensions = sampleDimensions;
    }

    private GroupAggregate(GroupAggregate source, Resource[] components) {
        super(source.listeners, true);
        this.name = source.name;
        this.envelope = source.envelope;
        this.envelopeIsEvaluated = source.envelopeIsEvaluated;
        this.sampleDimensions = source.sampleDimensions;
        this.componentsAreLeaves = source.componentsAreLeaves;
        this.components = components;
    }

    @Override
    public final synchronized Resource apply(MergeStrategy strategy) {
        boolean changed = false;
        Resource[] copy = (Resource[])this.components.clone();
        for (int i = 0; i < copy.length; ++i) {
            Resource c = copy[i];
            if (!(c instanceof AggregatedResource)) continue;
            AggregatedResource component = (AggregatedResource)((Object)c);
            copy[i] = component.apply(strategy);
            changed |= copy[i] != component;
        }
        return changed ? new GroupAggregate(this, copy) : this;
    }

    final <E extends Group<?>> void fillWithChildAggregates(Group<E> children, BiConsumer<E, GroupAggregate> childFiller) {
        assert (this.components.length == children.members.size());
        for (int i = 0; i < this.components.length; ++i) {
            Group member = (Group)children.members.get(i);
            GroupAggregate child = member.prepareAggregate(this.listeners);
            childFiller.accept(member, child);
            this.components[i] = child;
        }
    }

    final void fillWithCoverageComponents(List<GroupByTransform> children, List<SampleDimension> ranges) {
        this.componentsAreLeaves = true;
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = children.get(i).createResource(this.listeners, ranges);
        }
    }

    final Resource simplify(CoverageAggregator aggregator) {
        if (!this.componentsAreLeaves) {
            for (int i = 0; i < this.components.length; ++i) {
                Resource r = this.components[i];
                if (!(r instanceof GroupAggregate)) continue;
                this.components[i] = ((GroupAggregate)r).simplify(aggregator);
            }
        }
        if (this.components.length == 1) {
            Resource c = this.components[0];
            if (c instanceof AggregatedResource) {
                ((AggregatedResource)((Object)c)).setName(this.name);
            }
            return c;
        }
        return aggregator.existingAggregate(this.components).orElse(this);
    }

    @Override
    public void setIdentifier(GenericName identifier) {
        this.identifier = identifier;
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public Collection<Resource> components() {
        return UnmodifiableArrayList.wrap(this.components);
    }

    @Override
    public synchronized Optional<Envelope> getEnvelope() throws DataStoreException {
        if (!this.envelopeIsEvaluated) {
            try {
                this.envelope = GroupAggregate.unionOfComponents(this.components);
            }
            catch (TransformException e) {
                this.listeners.warning(e);
            }
            this.envelopeIsEvaluated = true;
        }
        return Optional.ofNullable(this.envelope);
    }

    static ImmutableEnvelope unionOfComponents(Resource[] components) throws DataStoreException, TransformException {
        Envelope[] envelopes = new Envelope[components.length];
        for (int i = 0; i < components.length; ++i) {
            Resource r = components[i];
            if (r instanceof AbstractResource) {
                envelopes[i] = ((AbstractResource)r).getEnvelope().orElse(null);
                continue;
            }
            if (!(r instanceof GridCoverageResource)) continue;
            envelopes[i] = ((GridCoverageResource)r).getEnvelope().orElse(null);
        }
        return ImmutableEnvelope.castOrCopy(Envelopes.union(envelopes));
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addTitle(this.name);
        try {
            builder.addExtent(this.envelope);
        }
        catch (TransformException e) {
            this.listeners.warning(e);
        }
        if (this.sampleDimensions != null) {
            for (SampleDimension band : this.sampleDimensions) {
                builder.addNewBand(band);
            }
        }
        return builder.build();
    }

    public String toString() {
        return Strings.toString(this.getClass(), "name", this.name, "size", this.components.length);
    }
}

