/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.referencing;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlElement;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public final class CC_OperationParameter
extends PropertyType<CC_OperationParameter, ParameterDescriptor<?>> {
    public Class<?> valueClass;
    public MeasurementRange<?> valueDomain;

    public CC_OperationParameter() {
    }

    @Override
    protected Class<ParameterDescriptor<?>> getBoundType() {
        return ParameterDescriptor.class;
    }

    private CC_OperationParameter(ParameterDescriptor<?> parameter) {
        super(parameter);
    }

    @Override
    protected CC_OperationParameter wrap(ParameterDescriptor<?> parameter) {
        return new CC_OperationParameter(parameter);
    }

    @XmlElement(name="OperationParameter")
    public DefaultParameterDescriptor<?> getElement() {
        return DefaultParameterDescriptor.castOrCopy((ParameterDescriptor)this.metadata);
    }

    public void setElement(DefaultParameterDescriptor<?> parameter) {
        this.metadata = parameter;
    }

    public static Class<?> valueClass(ParameterValue<?> param) {
        Object value = param.getValue();
        return value != null ? value.getClass() : null;
    }

    public static MeasurementRange<?> valueDomain(ParameterValue<?> param) {
        Unit<Object> unit = param.getUnit();
        if (unit == null) {
            return null;
        }
        if (Units.RADIAN.equals(unit = unit.getSystemUnit())) {
            unit = Units.DEGREE;
        }
        return MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, unit);
    }

    public void beforeUnmarshal(Unmarshaller caller, Object parent) {
        if (parent instanceof ParameterValue) {
            this.valueClass = CC_OperationParameter.valueClass((ParameterValue)parent);
            this.valueDomain = CC_OperationParameter.valueDomain((ParameterValue)parent);
            Context.setWrapper(Context.current(), this);
        }
    }

    public void afterUnmarshal(Unmarshaller caller, Object parent) {
        Context.setWrapper(Context.current(), null);
    }
}

