/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.managed;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.persistence.EntityManagerFactory;
import jakarta.transaction.Transaction;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.transaction.BeanTransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.PojoSerialization;

public class Instance
implements Serializable {
    private static final long serialVersionUID = 2862563626506556542L;
    public final BeanContext beanContext;
    public final Object primaryKey;
    public final Object bean;
    public final CreationalContext creationalContext;
    public final Map<String, Object> interceptors;
    private boolean inUse;
    private BeanTransactionPolicy.SuspendedTransaction beanTransaction;
    private final Stack<Transaction> transaction = new Stack();
    private final ReentrantLock lock = new ReentrantLock();
    private Map<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> entityManagers;
    private final JtaEntityManagerRegistry.EntityManagerTracker[] entityManagerArray;

    public Instance(BeanContext beanContext, Object primaryKey, Object bean, Map<String, Object> interceptors, CreationalContext creationalContext, Map<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> entityManagers) {
        this.beanContext = beanContext;
        this.primaryKey = primaryKey;
        this.bean = bean;
        this.interceptors = interceptors;
        this.creationalContext = creationalContext;
        this.entityManagers = entityManagers;
        this.entityManagerArray = null;
    }

    public Instance(Object deploymentId, Object primaryKey, Object bean, Map<String, Object> interceptors, CreationalContext creationalContext, JtaEntityManagerRegistry.EntityManagerTracker[] entityManagerArray) {
        this.beanContext = SystemInstance.get().getComponent(ContainerSystem.class).getBeanContext(deploymentId);
        if (this.beanContext == null) {
            throw new IllegalArgumentException("Unknown deployment " + deploymentId);
        }
        this.primaryKey = primaryKey;
        this.bean = bean;
        this.interceptors = interceptors;
        this.creationalContext = creationalContext;
        this.entityManagerArray = entityManagerArray;
    }

    public Duration getTimeOut() {
        return this.beanContext.getStatefulTimeout();
    }

    public synchronized boolean isInUse() {
        return this.inUse;
    }

    public synchronized void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public synchronized BeanTransactionPolicy.SuspendedTransaction getBeanTransaction() {
        return this.beanTransaction;
    }

    public synchronized void setBeanTransaction(BeanTransactionPolicy.SuspendedTransaction beanTransaction) {
        this.beanTransaction = beanTransaction;
    }

    public synchronized Transaction getTransaction() {
        return this.transaction.size() > 0 ? this.transaction.peek() : null;
    }

    public Lock getLock() {
        return this.lock;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (this.transaction.size() == 0 && transaction != null) {
            this.lock.lock();
            this.transaction.push(transaction);
        } else if (this.transaction.size() != 0 && transaction == null) {
            this.transaction.pop();
            this.lock.unlock();
        } else if (transaction != null) {
            this.transaction.push(transaction);
        }
    }

    public synchronized void releaseLock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    public synchronized Map<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker> getEntityManagers(Index<EntityManagerFactory, BeanContext.EntityManagerConfiguration> factories) {
        if (this.entityManagers == null && this.entityManagerArray != null) {
            this.entityManagers = new HashMap<EntityManagerFactory, JtaEntityManagerRegistry.EntityManagerTracker>();
            for (int i = 0; i < this.entityManagerArray.length; ++i) {
                EntityManagerFactory entityManagerFactory = factories.getKey(i);
                JtaEntityManagerRegistry.EntityManagerTracker entityManager = this.entityManagerArray[i];
                this.entityManagers.put(entityManagerFactory, entityManager);
            }
        }
        return this.entityManagers;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.inUse) {
            throw new IllegalStateException("Bean is still in use");
        }
        if (this.beanTransaction != null) {
            throw new IllegalStateException("Bean is associated with a bean-managed transaction");
        }
        return new Serialization(this);
    }

    private static class Serialization
    implements Serializable {
        private static final long serialVersionUID = 6002078080752564395L;
        public final Object deploymentId;
        public final Object primaryKey;
        public final Object bean;
        public final Map<String, Object> interceptors;
        public final CreationalContext creationalContext;
        public final JtaEntityManagerRegistry.EntityManagerTracker[] entityManagerArray;

        public Serialization(Instance i) {
            this.deploymentId = i.beanContext.getDeploymentID();
            this.primaryKey = i.primaryKey;
            this.bean = Serialization.toSerializable(i.bean);
            this.creationalContext = i.creationalContext;
            this.interceptors = new HashMap<String, Object>(i.interceptors.size());
            for (Map.Entry<String, Object> e : i.interceptors.entrySet()) {
                if (e.getValue() == i.bean) {
                    this.interceptors.put(e.getKey(), this.bean);
                    continue;
                }
                this.interceptors.put(e.getKey(), Serialization.toSerializable(e.getValue()));
            }
            this.entityManagerArray = i.entityManagerArray != null ? i.entityManagerArray : (i.entityManagers != null ? i.entityManagers.values().toArray(new JtaEntityManagerRegistry.EntityManagerTracker[i.entityManagers.values().size()]) : null);
        }

        private static Object toSerializable(Object obj) {
            if (obj instanceof Serializable) {
                return obj;
            }
            return new PojoSerialization(obj);
        }

        protected Object readResolve() throws ObjectStreamException {
            return new Instance(this.deploymentId, this.primaryKey, this.bean, this.interceptors, this.creationalContext, this.entityManagerArray);
        }
    }
}

