/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.ruta.textruler.learner.trabal;

/**
 * The type of a TraBaL condition. The attached comments show the corresponding RUTA-Conditions -
 * see RUTA rules for details.
 * 
 */
public enum ConditionType {

  STARTSWITH("STARTSWITH(", ")"),

  ENDSWITH("ENDSWITH(", ")"),

  AFTER("NEAR(", ", 1, 1, false, true)"),

  BEFORE("NEAR(", ", 1, 1, true, true)"),

  PARTOF("PARTOF(", ")"),

  CONTAINS("CONTAINS(", ")");

  String prefix, suffix;

  private ConditionType(String prefix, String suffix) {
    this.prefix = prefix;
    this.suffix = suffix;
  }

  public String getConditionString(String annotation) {
    return prefix + annotation + suffix;
  }
  
}
