/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Comment;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

final class CommentStatement
extends Statement {
    private final String _comment;

    CommentStatement(String comment) {
        super(-34);
        this._comment = comment;
    }

    final String getComment() {
        return this._comment;
    }

    public static void replaceAll(AstNode tree) {
        for (AstNode node : tree.getDescendants()) {
            if (!(node instanceof CommentStatement)) continue;
            node.getParent().insertChildBefore(node, new Comment(((CommentStatement)node).getComment()), Roles.COMMENT);
            node.remove();
        }
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return null;
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof CommentStatement && CommentStatement.matchString(this._comment, ((CommentStatement)other)._comment);
    }
}

