/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.Collection;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.FsIndexCollectionImportResolverAdapter;
import org.apache.uima.resource.metadata.impl.ImportResolver;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;

public class FsIndexCollection_impl
extends MetaDataObject_impl
implements FsIndexCollection {
    private static final long serialVersionUID = -7687383527183197102L;
    private static final FsIndexDescription[] EMPTY_FS_INDEX_DESCRIPTION_ARRAY = new FsIndexDescription[0];
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports = Import.EMPTY_IMPORTS;
    private FsIndexDescription[] mFsIndexes = EMPTY_FS_INDEX_DESCRIPTION_ARRAY;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("fsIndexCollection", new PropertyXmlInfo[]{new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("fsIndexes", "fsIndexes")});

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    @Override
    public Import[] getImports() {
        return this.mImports == null ? Import.EMPTY_IMPORTS : this.mImports;
    }

    @Override
    public void setImports(Import ... aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    @Override
    public FsIndexDescription[] getFsIndexes() {
        if (this.mFsIndexes == null) {
            this.mFsIndexes = EMPTY_FS_INDEX_DESCRIPTION_ARRAY;
        }
        return this.mFsIndexes;
    }

    @Override
    public void setFsIndexes(FsIndexDescription ... aFSIndexes) {
        if (aFSIndexes == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aFSIndexes", "setImports"});
        }
        this.mFsIndexes = aFSIndexes;
    }

    @Override
    public void addFsIndex(FsIndexDescription aFsIndexDescription) {
        FsIndexDescription[] current = this.getFsIndexes();
        FsIndexDescription[] newArr = new FsIndexDescription[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aFsIndexDescription;
        this.setFsIndexes(newArr);
    }

    @Override
    public void removeFsIndex(FsIndexDescription aFsIndexDescription) {
        FsIndexDescription[] current = this.getFsIndexes();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aFsIndexDescription) continue;
            FsIndexDescription[] newArr = new FsIndexDescription[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setFsIndexes(newArr);
            break;
        }
    }

    @Override
    public synchronized void resolveImports() throws InvalidXMLException {
        this.resolveImports(null, null);
    }

    @Override
    public synchronized void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(null, aResourceManager);
    }

    @Override
    @Deprecated
    public synchronized void resolveImports(Collection<String> aAlreadyImportedFsIndexURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        ImportResolver resolver = new ImportResolver(FsIndexCollectionImportResolverAdapter::new);
        resolver.resolveImports(this, aAlreadyImportedFsIndexURLs, aResourceManager);
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

