/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.impl.Logger_common_impl;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class Logger_impl
extends Logger_common_impl {
    private static final PrintStream defaultOut = System.out;
    private PrintStream mOut;
    private Level configLevel = Level.INFO;
    private String loggerName;
    private static final Logger_impl defaultLogger = new Logger_impl(null);

    private Logger_impl(Class<?> component) {
        super(component);
        this.mOut = defaultOut;
        this.loggerName = null == component ? "" : component.getName();
    }

    private Logger_impl(Logger_impl l, int limit) {
        super(l, limit);
        this.mOut = l.mOut;
        this.loggerName = l.loggerName;
    }

    public static synchronized Logger getInstance(Class<?> component) {
        return new Logger_impl(component);
    }

    public static synchronized Logger getInstance() {
        return defaultLogger;
    }

    @Override
    public Logger_impl getLimitedLogger(int aLimit) {
        if (aLimit == Integer.MAX_VALUE || aLimit == this.limit_common) {
            return this;
        }
        return new Logger_impl(this, aLimit);
    }

    @Override
    @Deprecated(since="2.3.1")
    public void setOutputStream(OutputStream out) {
        this.mOut = out == null || out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
    }

    @Override
    @Deprecated(since="2.3.1")
    public void setOutputStream(PrintStream out) {
        this.mOut = out;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.configLevel.isGreaterOrEqual(level);
    }

    @Override
    public boolean isLoggable(Level level, Marker marker) {
        return this.configLevel.isGreaterOrEqual(level);
    }

    @Override
    public void log(Marker m, String aFqcn, Level level, String message, Object[] args, Throwable thrown) {
        this.log(m, aFqcn, level, MessageFormat.format(message, args), thrown);
    }

    @Override
    public void log(Marker m, String aFqcn, Level level, String message, Throwable thrown) {
        if (this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + level.toString() + ": ");
            this.mOut.println(message);
            if (null != thrown) {
                thrown.printStackTrace(this.mOut);
            }
        }
    }

    @Override
    public void log2(Marker m, String aFqcn, Level level, String message, Object[] args, Throwable thrown) {
        if (this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + level.toString() + ": ");
            this.mOut.println(MessageFormatter.format((String)message, (Object)args).getMessage());
            if (null != thrown) {
                thrown.printStackTrace(this.mOut);
            }
        }
    }

    @Override
    public void setLevel(Level level) {
        this.configLevel = level;
    }

    public String getName() {
        return this.loggerName;
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Level.FINE);
    }

    public boolean isDebugEnabled(Marker arg0) {
        return this.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(Level.SEVERE);
    }

    public boolean isErrorEnabled(Marker arg0) {
        return this.isErrorEnabled();
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(Level.INFO) || this.isLoggable(Level.CONFIG);
    }

    public boolean isInfoEnabled(Marker arg0) {
        return this.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(Level.FINER) || this.isLoggable(Level.FINEST);
    }

    public boolean isTraceEnabled(Marker arg0) {
        return this.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isWarnEnabled(Marker arg0) {
        return this.isWarnEnabled();
    }
}

