/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.message.JmsOutboundMessageDispatch;
import org.apache.qpid.jms.meta.JmsProducerId;
import org.apache.qpid.jms.meta.JmsProducerInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.NoOpAsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.WrappedAsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpFixedProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProducer;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.builders.AmqpProducerBuilder;
import org.apache.qpid.jms.provider.exceptions.ProviderIllegalStateException;
import org.apache.qpid.jms.util.IdGenerator;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpAnonymousFallbackProducer
extends AmqpProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAnonymousFallbackProducer.class);
    private static final IdGenerator producerIdGenerator = new IdGenerator();
    private final AmqpConnection connection;
    private final Map<JmsDestination, AmqpFallbackProducer> producerCache = new LinkedHashMap<JmsDestination, AmqpFallbackProducer>(1, 0.75f, true);
    private final String producerIdKey = producerIdGenerator.generateId();
    private long producerIdCount;
    private final ScheduledFuture<?> cacheProducerTimeoutTask;

    public AmqpAnonymousFallbackProducer(AmqpSession session, JmsProducerInfo info) {
        super(session, info);
        this.connection = session.getConnection();
        long sweeperInterval = this.connection.getAnonymousProducerCacheTimeout();
        if (sweeperInterval > 0L && this.connection.getAnonymousProducerCacheSize() > 0) {
            LOG.trace("Cached Producer timeout monitoring enabled: interval = {}ms", (Object)sweeperInterval);
            this.cacheProducerTimeoutTask = this.connection.scheduleWithFixedDelay(new CachedProducerSweeper(), sweeperInterval);
        } else {
            LOG.trace("No Cached Producer timeout monitoring enabled based on configuration.");
            this.cacheProducerTimeoutTask = null;
        }
    }

    @Override
    public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        LOG.trace("Started send chain for anonymous producer: {}", (Object)this.getProducerId());
        AmqpFallbackProducer producer = this.producerCache.get(envelope.getDestination());
        if (producer != null && !producer.isAwaitingClose()) {
            producer.send(envelope, request);
        } else {
            this.handleSendWhenCachedProducerNotAvailable(envelope, request);
        }
    }

    private void handleSendWhenCachedProducerNotAvailable(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        AmqpFallbackProducer producer = this.producerCache.get(envelope.getDestination());
        if (producer != null && producer.isAwaitingClose()) {
            producer.close(new SendPendingCloseRequest(producer, envelope, request));
        } else if (this.producerCache.size() < this.connection.getAnonymousProducerCacheSize()) {
            this.startSendWithNewProducer(envelope, request);
        } else {
            this.startSendAfterOldestProducerEvicted(envelope, request);
        }
    }

    private void startSendAfterOldestProducerEvicted(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        if (this.producerCache.isEmpty()) {
            this.startSendWithNewProducer(envelope, request);
        } else {
            AmqpFallbackProducer producer = this.producerCache.values().iterator().next();
            LOG.trace("Next send will commence after producer: {} has been closed", (Object)producer);
            producer.close(new SendPendingCloseRequest(producer, envelope, request));
        }
    }

    private void startSendWithNewProducer(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
        LOG.trace("Next send will commence after producer for destination {} been opened", (Object)envelope.getDestination());
        JmsProducerInfo info = new JmsProducerInfo(this.getNextProducerId());
        info.setDestination(envelope.getDestination());
        info.setPresettle(((JmsProducerInfo)this.getResourceInfo()).isPresettle());
        AmqpFallbackProducerBuilder builder = new AmqpFallbackProducerBuilder(this.session, info);
        builder.buildResource(new FallbackProducerOpenRequest(request, builder, envelope));
        this.getParent().getProvider().pumpToProtonTransport(request);
    }

    @Override
    public void close(AsyncResult request) {
        if (this.cacheProducerTimeoutTask != null) {
            this.cacheProducerTimeoutTask.cancel(false);
        }
        if (this.producerCache.isEmpty()) {
            request.onSuccess();
        } else {
            AmqpAnonymousFallbackProducerCloseRequest aggregate = new AmqpAnonymousFallbackProducerCloseRequest(request, this.producerCache.size());
            LOG.trace("Anonymous Fallback Producer close will wait for close on {} cached producers", (Object)this.producerCache.size());
            ArrayList<AmqpFallbackProducer> pending = new ArrayList<AmqpFallbackProducer>(this.producerCache.values());
            for (AmqpFallbackProducer producer : pending) {
                producer.close(aggregate);
            }
            this.producerCache.clear();
        }
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public EndpointState getLocalState() {
        return EndpointState.ACTIVE;
    }

    @Override
    public EndpointState getRemoteState() {
        return EndpointState.ACTIVE;
    }

    private JmsProducerId getNextProducerId() {
        return new JmsProducerId(this.producerIdKey, -1L, this.producerIdCount++);
    }

    private final class CachedProducerSweeper
    implements Runnable {
        private CachedProducerSweeper() {
        }

        @Override
        public void run() {
            ArrayList<AmqpFallbackProducer> pending = new ArrayList<AmqpFallbackProducer>(AmqpAnonymousFallbackProducer.this.producerCache.values());
            for (AmqpFallbackProducer producer : pending) {
                if (!producer.isExpired()) continue;
                LOG.trace("Cached Producer {} has timed out, initiating close", (Object)producer);
                producer.close(new CloseRequest(producer));
            }
        }
    }

    private final class AmqpFallbackProducer
    extends AmqpFixedProducer {
        private int lastExpiryCheckValue;
        private int activityCounter;

        public AmqpFallbackProducer(AmqpSession session, JmsProducerInfo info, Sender sender, int maxInactiveTime) {
            super(session, info, sender);
        }

        @Override
        public void send(JmsOutboundMessageDispatch envelope, AsyncResult request) throws ProviderException {
            ++this.activityCounter;
            super.send(envelope, request);
        }

        @Override
        public void close(AsyncResult request) {
            if (this.isAwaitingClose()) {
                if (this.closeRequest instanceof CloseRequest) {
                    this.closeRequest = request;
                } else {
                    LOG.error("Close called on producer that already has a pending send on close request: ", (Object)this);
                    request.onFailure(new ProviderIllegalStateException("Illegal send on close call encountered in anonymous fallback producer"));
                }
            } else {
                super.close(request);
            }
            this.getParent().getProvider().pumpToProtonTransport();
        }

        public boolean isExpired() {
            if (!this.isAwaitingClose() && this.activityCounter == this.lastExpiryCheckValue) {
                return true;
            }
            this.lastExpiryCheckValue = this.activityCounter;
            return false;
        }

        @Override
        public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws ProviderException {
            ++this.activityCounter;
            super.processDeliveryUpdates(provider, delivery);
        }

        @Override
        public void processFlowUpdates(AmqpProvider provider) throws ProviderException {
            ++this.activityCounter;
            super.processFlowUpdates(provider);
        }

        @Override
        public void processRemoteClose(AmqpProvider provider) throws ProviderException {
            if (!this.isAwaitingClose()) {
                AmqpAnonymousFallbackProducer.this.producerCache.remove(((JmsProducerInfo)this.getResourceInfo()).getDestination());
            }
            super.processRemoteClose(provider);
        }
    }

    private final class SendPendingCloseRequest
    implements AsyncResult {
        private final JmsOutboundMessageDispatch envelope;
        private final AsyncResult sendRequest;
        private final AmqpFallbackProducer pendingCloseProducer;

        public SendPendingCloseRequest(AmqpFallbackProducer producer, JmsOutboundMessageDispatch envelope, AsyncResult sendRequest) {
            this.envelope = envelope;
            this.sendRequest = sendRequest;
            this.pendingCloseProducer = producer;
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.trace("Close of anonymous producer {} failed: {}", (Object)this.pendingCloseProducer, (Object)result);
            AmqpAnonymousFallbackProducer.this.producerCache.remove(((JmsProducerInfo)this.pendingCloseProducer.getResourceInfo()).getDestination());
            this.pendingCloseProducer.getParent().getProvider().fireProviderException(result);
            try {
                AmqpAnonymousFallbackProducer.this.send(this.envelope, this.sendRequest);
            }
            catch (ProviderException ex) {
                this.sendRequest.onFailure(ex);
            }
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close of anonymous producer {} complete", (Object)this.pendingCloseProducer);
            AmqpAnonymousFallbackProducer.this.producerCache.remove(((JmsProducerInfo)this.pendingCloseProducer.getResourceInfo()).getDestination());
            try {
                AmqpAnonymousFallbackProducer.this.send(this.envelope, this.sendRequest);
            }
            catch (ProviderException ex) {
                this.sendRequest.onFailure(ex);
            }
        }

        @Override
        public boolean isComplete() {
            return this.pendingCloseProducer.getRemoteState() == EndpointState.CLOSED;
        }
    }

    private final class AmqpFallbackProducerBuilder
    extends AmqpProducerBuilder {
        public AmqpFallbackProducerBuilder(AmqpSession parent, JmsProducerInfo resourceInfo) {
            super(parent, resourceInfo);
        }

        @Override
        protected AmqpProducer createResource(AmqpSession parent, JmsProducerInfo resourceInfo, Sender endpoint) {
            return new AmqpFallbackProducer((AmqpSession)this.getParent(), (JmsProducerInfo)this.getResourceInfo(), endpoint, AmqpAnonymousFallbackProducer.this.connection.getAnonymousProducerCacheTimeout());
        }
    }

    private final class FallbackProducerOpenRequest
    extends WrappedAsyncResult {
        private final JmsOutboundMessageDispatch envelope;
        private final AmqpProducerBuilder producerBuilder;

        public FallbackProducerOpenRequest(AsyncResult sendResult, AmqpProducerBuilder producerBuilder, JmsOutboundMessageDispatch envelope) {
            super(sendResult);
            this.envelope = envelope;
            this.producerBuilder = producerBuilder;
        }

        @Override
        public void onSuccess() {
            LOG.trace("Open phase of anonymous send complete: {} ", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            AmqpFallbackProducer producer = (AmqpFallbackProducer)this.producerBuilder.getResource();
            AmqpAnonymousFallbackProducer.this.producerCache.put(this.envelope.getDestination(), producer);
            boolean closeNow = AmqpAnonymousFallbackProducer.this.connection.getAnonymousProducerCacheSize() <= 0;
            try {
                producer.send(this.envelope, this.getWrappedRequest());
            }
            catch (ProviderException e) {
                closeNow = true;
                super.onFailure(e);
            }
            if (closeNow) {
                LOG.trace("Immediate close of fallback producer {} after send triggered.", (Object)producer);
                producer.close(new CloseRequest(producer));
            }
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.debug("Anonymous fallback Send failed because open of new fixed producer failed: {}", (Object)AmqpAnonymousFallbackProducer.this.getProducerId());
            ((AmqpProducer)this.producerBuilder.getResource()).close(NoOpAsyncResult.INSTANCE);
            super.onFailure(result);
        }
    }

    private final class AmqpAnonymousFallbackProducerCloseRequest
    extends WrappedAsyncResult {
        private int pendingCloseRequests;
        private ProviderException firstFailure;

        public AmqpAnonymousFallbackProducerCloseRequest(AsyncResult request, int pendingCloseRequets) {
            super(request);
            this.pendingCloseRequests = pendingCloseRequets;
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.trace("Close of one anonymous producer done (with error), remaining: {}", (Object)this.pendingCloseRequests);
            --this.pendingCloseRequests;
            ProviderException providerException = this.firstFailure = this.firstFailure == null ? result : this.firstFailure;
            if (this.pendingCloseRequests == 0) {
                super.onFailure(this.firstFailure);
            }
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close of one anonymous producer done, remaining: {}", (Object)this.pendingCloseRequests);
            --this.pendingCloseRequests;
            if (this.pendingCloseRequests == 0) {
                if (this.firstFailure == null) {
                    super.onSuccess();
                } else {
                    super.onFailure(this.firstFailure);
                }
            }
        }

        @Override
        public boolean isComplete() {
            return this.pendingCloseRequests == 0;
        }
    }

    private final class CloseRequest
    implements AsyncResult {
        private final AmqpFallbackProducer producer;

        public CloseRequest(AmqpFallbackProducer producer) {
            this.producer = producer;
        }

        @Override
        public void onFailure(ProviderException result) {
            LOG.trace("Close of anonymous producer {} failed: {}", (Object)this.producer, (Object)result);
            AmqpAnonymousFallbackProducer.this.producerCache.remove(((JmsProducerInfo)this.producer.getResourceInfo()).getDestination());
            this.producer.getParent().getProvider().fireProviderException(result);
        }

        @Override
        public void onSuccess() {
            LOG.trace("Close of anonymous producer {} complete", (Object)this.producer);
            AmqpAnonymousFallbackProducer.this.producerCache.remove(((JmsProducerInfo)this.producer.getResourceInfo()).getDestination());
        }

        @Override
        public boolean isComplete() {
            return this.producer.isClosed();
        }
    }
}

