/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres.sqltree;

import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;

public class PostgresLimitOffsetNode
extends LimitOffsetNode {
    public PostgresLimitOffsetNode(LimitOffsetNode node) {
        super(node.getLimit(), node.getOffset());
    }

    private PostgresLimitOffsetNode(int limit, int offset) {
        super(limit, offset);
    }

    @Override
    public QuotingAppendable append(QuotingAppendable buffer) {
        if (this.limit == 0 && this.offset == 0) {
            return buffer;
        }
        if (this.limit > 0) {
            buffer.append(" LIMIT ").append(this.limit);
        }
        if (this.offset > 0) {
            buffer.append(" OFFSET ").append(this.offset);
        }
        return buffer;
    }

    @Override
    public Node copy() {
        return new PostgresLimitOffsetNode(this.limit, this.offset);
    }
}

