/*
 * Decompiled with CFR 0.152.
 */
package groovy.console.ui.text;

import java.awt.AWTPermission;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;

public final class StructuredSyntaxResources {
    public static final Clipboard SYSTEM_CLIPBOARD = StructuredSyntaxResources.getSystemOrAppLevelClipboard();
    public static final Font LARGE_FONT = Font.decode("Arial-24");
    public static final Font MEDIUM_FONT = Font.decode("Arial-18");
    public static final Font SMALL_FONT = Font.decode("Arial-12");
    public static final Font EDITOR_FONT = Font.decode("Monospaced-12");
    public static final String UNDO = "Undo";
    public static final String REDO = "Redo";
    public static final String PRINT = "Print";
    public static final String FIND = "Find";
    public static final String FIND_NEXT = "Find Next";
    public static final String REPLACE = "Replace";

    private static Clipboard getSystemOrAppLevelClipboard() {
        Clipboard systemClipboard = StructuredSyntaxResources.getSystemClipboard();
        if (systemClipboard == null) {
            systemClipboard = new Clipboard("UIResourceMgr");
        }
        return systemClipboard;
    }

    private static Clipboard getSystemClipboard() {
        try {
            SecurityManager mgr = System.getSecurityManager();
            if (mgr != null) {
                mgr.checkPermission(new AWTPermission("accessClipboard"));
            }
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            return null;
        }
    }

    private StructuredSyntaxResources() {
    }
}

