/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.freelist;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.jetbrains.annotations.Nullable;

public class IndexColumns
implements Storable {
    public static final byte DATA_TYPE = 1;
    public static final int SIZE_OFFSET = 1;
    public static final int VALUE_OFFSET = 5;
    private final int partitionId;
    private long link = 0L;
    @Nullable
    private final ByteBuffer valueBuffer;

    public IndexColumns(int partitionId, @Nullable ByteBuffer valueBuffer) {
        this.partitionId = partitionId;
        this.valueBuffer = valueBuffer;
    }

    public IndexColumns(int partitionId, long link, @Nullable ByteBuffer valueBuffer) {
        this.partitionId = partitionId;
        this.link = link;
        this.valueBuffer = valueBuffer;
    }

    public int valueSize() {
        assert (this.valueBuffer != null);
        return this.valueBuffer.limit();
    }

    public ByteBuffer valueBuffer() {
        return this.valueBuffer;
    }

    public void link(long link) {
        this.link = link;
    }

    public long link() {
        return this.link;
    }

    public int partition() {
        return this.partitionId;
    }

    public int size() throws IgniteInternalCheckedException {
        return 5 + this.valueSize();
    }

    public int headerSize() {
        return 6;
    }

    public void writeRowData(long pageAddr, int dataOff, int payloadSize, boolean newRow) {
        PageUtils.putShort((long)pageAddr, (int)dataOff, (short)((short)payloadSize));
        PageUtils.putByte((long)pageAddr, (int)((dataOff += 2) + 0), (byte)1);
        PageUtils.putInt((long)pageAddr, (int)(dataOff + 1), (int)this.valueSize());
        PageUtils.putByteBuffer((long)pageAddr, (int)(dataOff + 5), (ByteBuffer)this.valueBuffer());
    }

    public void writeFragmentData(ByteBuffer pageBuf, int rowOff, int payloadSize) {
        if (rowOff == 0) {
            assert (this.headerSize() <= payloadSize);
            pageBuf.put((byte)1);
            pageBuf.putInt(this.valueSize());
            Storable.putValueBufferIntoPage((ByteBuffer)pageBuf, (ByteBuffer)this.valueBuffer, (int)0, (int)(payloadSize - 5));
        } else {
            assert (rowOff >= this.headerSize());
            Storable.putValueBufferIntoPage((ByteBuffer)pageBuf, (ByteBuffer)this.valueBuffer, (int)(rowOff - 5), (int)payloadSize);
        }
    }
}

