/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;

public class PipeTransferTabletBatchReq
extends TPipeTransferReq {
    private final transient List<PipeTransferTabletBinaryReq> binaryReqs = new ArrayList<PipeTransferTabletBinaryReq>();
    private final transient List<PipeTransferTabletInsertNodeReq> insertNodeReqs = new ArrayList<PipeTransferTabletInsertNodeReq>();
    private final transient List<PipeTransferTabletRawReq> tabletReqs = new ArrayList<PipeTransferTabletRawReq>();

    private PipeTransferTabletBatchReq() {
    }

    public Pair<InsertRowsStatement, InsertMultiTabletsStatement> constructStatements() {
        InsertBaseStatement statement;
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (PipeTransferTabletBinaryReq binaryReq : this.binaryReqs) {
            statement = binaryReq.constructStatement();
            if (statement.isEmpty()) continue;
            if (statement instanceof InsertRowStatement) {
                insertRowStatementList.add((InsertRowStatement)statement);
                continue;
            }
            if (statement instanceof InsertTabletStatement) {
                insertTabletStatementList.add((InsertTabletStatement)statement);
                continue;
            }
            if (statement instanceof InsertRowsStatement) {
                insertRowStatementList.addAll(((InsertRowsStatement)statement).getInsertRowStatementList());
                continue;
            }
            throw new UnsupportedOperationException(String.format("unknown InsertBaseStatement %s constructed from PipeTransferTabletBinaryReq.", new Object[]{binaryReq}));
        }
        for (PipeTransferTabletInsertNodeReq insertNodeReq : this.insertNodeReqs) {
            statement = insertNodeReq.constructStatement();
            if (statement.isEmpty()) continue;
            if (statement instanceof InsertRowStatement) {
                insertRowStatementList.add((InsertRowStatement)statement);
                continue;
            }
            if (statement instanceof InsertTabletStatement) {
                insertTabletStatementList.add((InsertTabletStatement)statement);
                continue;
            }
            if (statement instanceof InsertRowsStatement) {
                insertRowStatementList.addAll(((InsertRowsStatement)statement).getInsertRowStatementList());
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unknown InsertBaseStatement %s constructed from PipeTransferTabletInsertNodeReq.", statement));
        }
        for (PipeTransferTabletRawReq tabletReq : this.tabletReqs) {
            statement = tabletReq.constructStatement();
            if (((InsertTabletStatement)statement).isEmpty()) continue;
            insertTabletStatementList.add((InsertTabletStatement)statement);
        }
        insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        return new Pair((Object)insertRowsStatement, (Object)insertMultiTabletsStatement);
    }

    public static PipeTransferTabletBatchReq toTPipeTransferReq(List<ByteBuffer> binaryBuffers, List<ByteBuffer> insertNodeBuffers, List<ByteBuffer> tabletBuffers) throws IOException {
        PipeTransferTabletBatchReq batchReq = new PipeTransferTabletBatchReq();
        batchReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        batchReq.type = PipeRequestType.TRANSFER_TABLET_BATCH.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.write((int)binaryBuffers.size(), (OutputStream)outputStream);
            for (ByteBuffer binaryBuffer : binaryBuffers) {
                ReadWriteIOUtils.write((int)binaryBuffer.limit(), (OutputStream)outputStream);
                outputStream.write(binaryBuffer.array(), 0, binaryBuffer.limit());
            }
            ReadWriteIOUtils.write((int)insertNodeBuffers.size(), (OutputStream)outputStream);
            for (ByteBuffer insertNodeBuffer : insertNodeBuffers) {
                outputStream.write(insertNodeBuffer.array(), 0, insertNodeBuffer.limit());
            }
            ReadWriteIOUtils.write((int)tabletBuffers.size(), (OutputStream)outputStream);
            for (ByteBuffer tabletBuffer : tabletBuffers) {
                outputStream.write(tabletBuffer.array(), 0, tabletBuffer.limit());
            }
            batchReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return batchReq;
    }

    public static PipeTransferTabletBatchReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        int i;
        PipeTransferTabletBatchReq batchReq = new PipeTransferTabletBatchReq();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            int length = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
            byte[] body = new byte[length];
            transferReq.body.get(body);
            batchReq.binaryReqs.add(PipeTransferTabletBinaryReq.toTPipeTransferReq(ByteBuffer.wrap(body)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            batchReq.insertNodeReqs.add(PipeTransferTabletInsertNodeReq.toTPipeTransferRawReq((InsertNode)PlanFragment.deserializeHelper(transferReq.body, null)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)transferReq.body);
        for (i = 0; i < size; ++i) {
            batchReq.tabletReqs.add(PipeTransferTabletRawReq.toTPipeTransferRawReq(Tablet.deserialize((ByteBuffer)transferReq.body), ReadWriteIOUtils.readBool((ByteBuffer)transferReq.body)));
        }
        batchReq.version = transferReq.version;
        batchReq.type = transferReq.type;
        return batchReq;
    }

    public List<PipeTransferTabletBinaryReq> getBinaryReqs() {
        return this.binaryReqs;
    }

    public List<PipeTransferTabletInsertNodeReq> getInsertNodeReqs() {
        return this.insertNodeReqs;
    }

    public List<PipeTransferTabletRawReq> getTabletReqs() {
        return this.tabletReqs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletBatchReq that = (PipeTransferTabletBatchReq)((Object)obj);
        return this.binaryReqs.equals(that.binaryReqs) && this.insertNodeReqs.equals(that.insertNodeReqs) && this.tabletReqs.equals(that.tabletReqs) && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.binaryReqs, this.insertNodeReqs, this.tabletReqs, this.version, this.type, this.body);
    }
}

