/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

public class EventFilter
extends MonitoringFilter
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=725");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=726");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=727");
    private final SimpleAttributeOperand[] selectClauses;
    private final ContentFilter whereClause;

    public EventFilter(SimpleAttributeOperand[] selectClauses, ContentFilter whereClause) {
        this.selectClauses = selectClauses;
        this.whereClause = whereClause;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public SimpleAttributeOperand[] getSelectClauses() {
        return this.selectClauses;
    }

    public ContentFilter getWhereClause() {
        return this.whereClause;
    }

    protected EventFilter(EventFilterBuilder<?, ?> b) {
        super((MonitoringFilter.MonitoringFilterBuilder<?, ?>)b);
        this.selectClauses = ((EventFilterBuilder)b).selectClauses;
        this.whereClause = ((EventFilterBuilder)b).whereClause;
    }

    public static EventFilterBuilder<?, ?> builder() {
        return new EventFilterBuilderImpl();
    }

    public EventFilterBuilder<?, ?> toBuilder() {
        return new EventFilterBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSelectClauses(), other.getSelectClauses())) {
            return false;
        }
        ContentFilter this$whereClause = this.getWhereClause();
        ContentFilter other$whereClause = other.getWhereClause();
        return !(this$whereClause == null ? other$whereClause != null : !((Object)this$whereClause).equals(other$whereClause));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EventFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getSelectClauses());
        ContentFilter $whereClause = this.getWhereClause();
        result = result * 59 + ($whereClause == null ? 43 : ((Object)$whereClause).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EventFilter(selectClauses=" + Arrays.deepToString(this.getSelectClauses()) + ", whereClause=" + this.getWhereClause() + ")";
    }

    private static final class EventFilterBuilderImpl
    extends EventFilterBuilder<EventFilter, EventFilterBuilderImpl> {
        private EventFilterBuilderImpl() {
        }

        @Override
        protected EventFilterBuilderImpl self() {
            return this;
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this);
        }
    }

    public static abstract class EventFilterBuilder<C extends EventFilter, B extends EventFilterBuilder<C, B>>
    extends MonitoringFilter.MonitoringFilterBuilder<C, B> {
        private SimpleAttributeOperand[] selectClauses;
        private ContentFilter whereClause;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            EventFilterBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(EventFilter instance, EventFilterBuilder<?, ?> b) {
            b.selectClauses(instance.selectClauses);
            b.whereClause(instance.whereClause);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B selectClauses(SimpleAttributeOperand[] selectClauses) {
            this.selectClauses = selectClauses;
            return (B)this.self();
        }

        public B whereClause(ContentFilter whereClause) {
            this.whereClause = whereClause;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "EventFilter.EventFilterBuilder(super=" + super.toString() + ", selectClauses=" + Arrays.deepToString(this.selectClauses) + ", whereClause=" + this.whereClause + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<EventFilter> {
        @Override
        public Class<EventFilter> getType() {
            return EventFilter.class;
        }

        @Override
        public EventFilter decode(SerializationContext context, UaDecoder decoder) {
            SimpleAttributeOperand[] selectClauses = (SimpleAttributeOperand[])decoder.readStructArray("SelectClauses", SimpleAttributeOperand.TYPE_ID);
            ContentFilter whereClause = (ContentFilter)decoder.readStruct("WhereClause", ContentFilter.TYPE_ID);
            return new EventFilter(selectClauses, whereClause);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EventFilter value) {
            encoder.writeStructArray("SelectClauses", (Object[])value.getSelectClauses(), SimpleAttributeOperand.TYPE_ID);
            encoder.writeStruct("WhereClause", (Object)value.getWhereClause(), ContentFilter.TYPE_ID);
        }
    }
}

