/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.exception;

import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.rpc.TSStatusCode;

public class ConfigurationException
extends IoTDBException {
    private String parameter;
    private String correctValue;

    public ConfigurationException(String parameter, String badValue, String correctValue, String reason) {
        super(String.format("Parameter %s can not be %s, please set to: %s. Because %s", parameter, badValue, correctValue, reason), TSStatusCode.CONFIGURATION_ERROR.getStatusCode());
        this.parameter = parameter;
        this.correctValue = correctValue;
    }

    public ConfigurationException(String reason) {
        super(reason, TSStatusCode.CONFIGURATION_ERROR.getStatusCode());
    }

    @TestOnly
    public String getParameter() {
        return this.parameter;
    }

    @TestOnly
    public String getCorrectValue() {
        return this.correctValue;
    }
}

