/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.riot.system.streammgr;

import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.http.HttpOp;
import org.apache.jena.riot.RiotException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** Support for resources using the "ftp:" scheme */
public class LocatorFTP extends LocatorURL {
    private static Logger         log         = LoggerFactory.getLogger(LocatorFTP.class);
    private static final String[] schemeNames = { "ftp" };

    public LocatorFTP() {
        super(schemeNames);
    }

    @Override
    protected Logger log() { return log; }

    @Override
    public TypedInputStream performOpen(String uri) {
        if ( uri.startsWith("ftp://") ) {
            try {
                return HttpOp.httpGet(uri);
            }
            catch (HttpException ex) {
                throw new RiotException("Bad FTP URL: "+uri, ex);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "LocatorFTP";
    }

    @Override
    public int hashCode() {
        return 57;
    }
}
