/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.differ;

import aQute.bnd.differ.Element;
import aQute.bnd.differ.JavaElement;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.About;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.diff.Delta;
import aQute.bnd.service.diff.Differ;
import aQute.bnd.service.diff.Tree;
import aQute.bnd.service.diff.Type;
import aQute.bnd.unmodifiable.Sets;
import aQute.bnd.version.Version;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.Digester;
import aQute.libg.cryptography.SHA1;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DiffPluginImpl
implements Differ {
    static final Set<String> MAJOR_HEADERS = Sets.of("Export-Package", "Import-Package", "Require-Bundle", "Fragment-Host", "Bundle-SymbolicName", "Bundle-License", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "DynamicImport-Package", "Bundle-Version");
    static final Set<String> IGNORED_HEADERS = Sets.of("Tool", "Bnd-LastModified", "Created-By");
    static final Set<String> ORDERED_HEADERS = Sets.of("Service-Component", "Test-Cases");
    Instructions localIgnore = null;

    public Tree tree(File newer) throws Exception {
        try (Jar jnewer = new Jar(newer);){
            Tree tree = this.tree(jnewer);
            return tree;
        }
    }

    @Override
    public Tree tree(Jar newer) throws Exception {
        try (Analyzer anewer = new Analyzer(newer);){
            Tree tree = this.tree(anewer);
            return tree;
        }
    }

    @Override
    public Tree tree(Analyzer newer) throws Exception {
        return this.bundleElement(newer);
    }

    private Element bundleElement(Analyzer analyzer) throws Exception {
        ArrayList<Element> result = new ArrayList<Element>();
        Manifest manifest = analyzer.getJar().getManifest();
        if (manifest != null) {
            result.add(JavaElement.getAPI(analyzer));
            result.add(this.manifestElement(manifest));
        }
        result.add(this.resourcesElement(analyzer));
        return new Element(Type.BUNDLE, analyzer.getJar().getName(), result, Delta.CHANGED, Delta.CHANGED, null);
    }

    private Element resourcesElement(Analyzer analyzer) throws Exception {
        Jar jar = analyzer.getJar();
        ArrayList<Element> resources = new ArrayList<Element>();
        for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
            String path = entry.getKey();
            if (jar.getManifestName().equals(path) || Jar.METAINF_SIGNING_P.matcher(path).matches() || this.localIgnore != null && this.localIgnore.matches(path) || path.endsWith("<<EMPTY>>") || analyzer.since(About._3_0) && this.hasSource(analyzer, path)) continue;
            Resource resource = entry.getValue();
            InputStream in = resource.openInputStream();
            try {
                Digester<SHA1> digester = SHA1.getDigester(new OutputStream[0]);
                try {
                    IO.copy(in, digester);
                    String value = Hex.toHexString(digester.digest().digest());
                    resources.add(new Element(Type.RESOURCE, entry.getKey(), Arrays.asList(new Element(Type.SHA, value)), Delta.CHANGED, Delta.CHANGED, null));
                }
                finally {
                    if (digester == null) continue;
                    digester.close();
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return new Element(Type.RESOURCES, "<resources>", resources, Delta.CHANGED, Delta.CHANGED, null);
    }

    private boolean hasSource(Analyzer analyzer, String path) throws Exception {
        if (!path.endsWith(".class")) {
            return false;
        }
        Descriptors.TypeRef type = analyzer.getTypeRefFromPath(path);
        Descriptors.PackageRef packageRef = type.getPackageRef();
        Clazz clazz = analyzer.findClass(type);
        if (clazz == null) {
            return false;
        }
        String sourceFile = clazz.getSourceFile();
        if (sourceFile == null) {
            return false;
        }
        String source = "OSGI-OPT/src/" + packageRef.getBinary() + "/" + sourceFile;
        Resource sourceResource = analyzer.getJar().getResource(source);
        return sourceResource != null;
    }

    private Element manifestElement(Manifest manifest) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Object key : manifest.getMainAttributes().keySet()) {
            String header = key.toString();
            String value = manifest.getMainAttributes().getValue((Attributes.Name)key);
            if (IGNORED_HEADERS.contains(header) || this.localIgnore != null && this.localIgnore.matches(header)) continue;
            if (MAJOR_HEADERS.contains(header)) {
                if (header.equalsIgnoreCase("Bundle-Version")) {
                    String v = new Version(value).toStringWithoutQualifier();
                    result.add(new Element(Type.HEADER, header + ":" + v, null, Delta.CHANGED, Delta.CHANGED, null));
                    continue;
                }
                Parameters clauses = OSGiHeader.parseHeader(value);
                ArrayList<Element> clausesDef = new ArrayList<Element>();
                for (Map.Entry<String, Attrs> clause : clauses.entrySet()) {
                    ArrayList<Element> parameterDef = new ArrayList<Element>();
                    for (Map.Entry<String, String> parameter : clause.getValue().entrySet()) {
                        String paramValue = parameter.getValue();
                        if ("Export-Package".equals(header) && "uses:".equals(parameter.getKey())) {
                            paramValue = Strings.splitAsStream(paramValue).sorted().collect(Strings.joining());
                        }
                        parameterDef.add(new Element(Type.PARAMETER, parameter.getKey() + ":" + paramValue, null, Delta.CHANGED, Delta.CHANGED, null));
                    }
                    clausesDef.add(new Element(Type.CLAUSE, clause.getKey(), parameterDef, Delta.CHANGED, Delta.CHANGED, null));
                }
                result.add(new Element(Type.HEADER, header, clausesDef, Delta.CHANGED, Delta.CHANGED, null));
                continue;
            }
            if (ORDERED_HEADERS.contains(header)) {
                String sorted = Strings.splitAsStream(value).sorted().collect(Strings.joining());
                result.add(new Element(Type.HEADER, header + ":" + sorted, null, Delta.CHANGED, Delta.CHANGED, null));
                continue;
            }
            result.add(new Element(Type.HEADER, header + ":" + value, null, Delta.CHANGED, Delta.CHANGED, null));
        }
        return new Element(Type.MANIFEST, "<manifest>", result, Delta.CHANGED, Delta.CHANGED, null);
    }

    @Override
    public Tree deserialize(Tree.Data data) throws Exception {
        return new Element(data);
    }

    public void setIgnore(String diffignore) {
        this.setIgnore(new Parameters(diffignore));
    }

    public void setIgnore(Parameters diffignore) {
        if (diffignore == null || diffignore.isEmpty()) {
            this.localIgnore = null;
            return;
        }
        this.localIgnore = new Instructions(diffignore);
    }
}

