/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces.core;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.DateTimeConverter;
import jakarta.faces.view.facelets.ConverterConfig;
import jakarta.faces.view.facelets.ConverterHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.util.TimeZone;
import org.apache.myfaces.view.facelets.tag.faces.ComponentSupport;

public final class ConvertDateTimeHandler
extends ConverterHandler {
    private final TagAttribute dateStyle = this.getAttribute("dateStyle");
    private final TagAttribute locale = this.getAttribute("locale");
    private final TagAttribute pattern = this.getAttribute("pattern");
    private final TagAttribute timeStyle = this.getAttribute("timeStyle");
    private final TagAttribute timeZone = this.getAttribute("timeZone");
    private final TagAttribute type = this.getAttribute("type");

    public ConvertDateTimeHandler(ConverterConfig config) {
        super(config);
    }

    protected Converter createConverter(FaceletContext ctx) throws FacesException, ELException, FaceletException {
        return ctx.getFacesContext().getApplication().createConverter("jakarta.faces.DateTime");
    }

    public void setAttributes(FaceletContext ctx, Object obj) {
        Object t;
        DateTimeConverter c = (DateTimeConverter)obj;
        if (this.locale != null) {
            c.setLocale(ComponentSupport.getLocale(ctx, this.locale));
        }
        if (this.type != null) {
            c.setType(this.type.getValue(ctx));
        }
        if (this.pattern != null) {
            c.setPattern(this.pattern.getValue(ctx));
        }
        if (this.dateStyle != null) {
            c.setDateStyle(this.dateStyle.getValue(ctx));
        }
        if (this.timeStyle != null) {
            c.setTimeStyle(this.timeStyle.getValue(ctx));
        }
        if (this.timeZone != null && (t = this.timeZone.getObject(ctx)) != null) {
            if (t instanceof TimeZone) {
                c.setTimeZone((TimeZone)t);
            } else if (t instanceof String) {
                TimeZone tz = TimeZone.getTimeZone((String)t);
                c.setTimeZone(tz);
            } else {
                throw new TagAttributeException(this.tag, this.timeZone, "Illegal TimeZone, must evaluate to either a java.util.TimeZone or String, is type: " + String.valueOf(t.getClass()));
            }
        }
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return super.createMetaRuleset(type).ignoreAll();
    }
}

