/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.Configuration;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import org.apache.netbeans.nbpackage.Template;
import org.apache.netbeans.nbpackage.appimage.AppImagePackager;
import org.apache.netbeans.nbpackage.deb.DebPackager;
import org.apache.netbeans.nbpackage.innosetup.InnoSetupPackager;
import org.apache.netbeans.nbpackage.macos.PkgPackager;
import org.apache.netbeans.nbpackage.rpm.RpmPackager;
import org.apache.netbeans.nbpackage.zip.ZipPackager;

public final class NBPackage {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle(NBPackage.class.getPackageName() + ".Messages");
    public static final Option<String> PACKAGE_NAME = Option.ofString("package.name", MESSAGES.getString("option.name.help"));
    public static final Option<String> PACKAGE_VERSION = Option.ofString("package.version", "1.0", MESSAGES.getString("option.version.help"));
    public static final Option<String> PACKAGE_TYPE = Option.ofString("package.type", MESSAGES.getString("option.type.help"));
    public static final Option<Path> PACKAGE_RUNTIME = Option.ofPath("package.runtime", MESSAGES.getString("option.runtime.help"));
    public static final Option<String> PACKAGE_ARCH = Option.ofString("package.arch", MESSAGES.getString("option.arch.help"));
    public static final Option<String> PACKAGE_PUBLISHER = Option.ofString("package.publisher", MESSAGES.getString("option.publisher.default"), MESSAGES.getString("option.publisher.help"));
    public static final Option<URI> PACKAGE_URL = Option.of("package.url", URI.class, "", s -> {
        URI uri = new URI(s);
        if (uri.isAbsolute()) {
            return uri;
        }
        throw new IllegalArgumentException();
    }, MESSAGES.getString("option.url.help"));
    public static final Option<String> PACKAGE_DESCRIPTION = Option.ofString("package.description", MESSAGES.getString("option.description.default"), MESSAGES.getString("option.description.help"));
    public static final Option<Path> PACKAGE_MERGE = Option.ofPath("package.merge", MESSAGES.getString("option.merge.help"));
    public static final Option<String> PACKAGE_REMOVE = Option.ofString("package.remove", MESSAGES.getString("option.remove.help"));
    private static final List<Packager> PACKAGERS = List.of(new AppImagePackager(), new DebPackager(), new RpmPackager(), new InnoSetupPackager(), new PkgPackager(), new ZipPackager());
    private static final List<Option<?>> GLOBAL_OPTIONS = List.of(PACKAGE_NAME, PACKAGE_VERSION, PACKAGE_TYPE, PACKAGE_RUNTIME, PACKAGE_ARCH, PACKAGE_DESCRIPTION, PACKAGE_PUBLISHER, PACKAGE_URL, PACKAGE_MERGE, PACKAGE_REMOVE);

    private NBPackage() {
    }

    public static Path createPackage(Path input, Configuration configuration, Path destination) throws Exception {
        Packager packager = NBPackage.findPackager(configuration.getValue(PACKAGE_TYPE));
        ExecutionContext exec = new ExecutionContext(packager, input.toAbsolutePath(), configuration, destination.toAbsolutePath(), false);
        return exec.execute();
    }

    public static Path createImage(Path input, Configuration configuration, Path destination) throws Exception {
        Packager packager = NBPackage.findPackager(configuration.getValue(PACKAGE_TYPE));
        ExecutionContext exec = new ExecutionContext(packager, input.toAbsolutePath(), configuration, destination.toAbsolutePath(), true);
        return exec.execute();
    }

    public static Path packageImage(Path inputImage, Configuration configuration, Path destination) throws Exception {
        Packager packager = NBPackage.findPackager(configuration.getValue(PACKAGE_TYPE));
        ExecutionContext exec = new ExecutionContext(packager, inputImage.toAbsolutePath(), configuration, destination.toAbsolutePath());
        return exec.execute();
    }

    public static String writeFullConfiguration(Configuration configuration, boolean includeComments) {
        String type = configuration.getValue(PACKAGE_TYPE);
        StringBuilder sb = new StringBuilder();
        Stream<Option<?>> options = type.isBlank() ? NBPackage.options() : NBPackage.options(type);
        options.forEachOrdered(o -> NBPackage.writeOption(sb, configuration, o, includeComments));
        return sb.toString();
    }

    public static void writeFullConfiguration(Configuration configuration, Path destination) throws IOException {
        Files.writeString(destination.toAbsolutePath(), (CharSequence)NBPackage.writeFullConfiguration(configuration, true), StandardOpenOption.CREATE_NEW);
    }

    public static void copyTemplates(Configuration configuration, Path destination) throws IOException {
        Template[] templates;
        Files.createDirectories(destination, new FileAttribute[0]);
        String type = configuration.getValue(PACKAGE_TYPE);
        for (Template template : templates = (Template[])(type.isBlank() ? NBPackage.templates() : NBPackage.templates(type)).toArray(Template[]::new)) {
            String contents = template.load(configuration);
            Files.writeString(destination.resolve(template.name()), (CharSequence)contents, StandardOpenOption.CREATE_NEW);
        }
    }

    public static Stream<Packager> packagers() {
        return PACKAGERS.stream();
    }

    public static Packager findPackager(String name) {
        if (name.isBlank()) {
            throw new IllegalArgumentException(MESSAGES.getString("message.notype"));
        }
        return NBPackage.packagers().filter(p -> name.equals(p.name())).findFirst().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format(MESSAGES.getString("message.invalidtype"), name)));
    }

    public static Stream<Option<?>> globalOptions() {
        return GLOBAL_OPTIONS.stream();
    }

    public static Stream<Option<?>> options() {
        return Stream.concat(NBPackage.globalOptions(), NBPackage.packagers().flatMap(Packager::options));
    }

    public static Stream<Option<?>> options(String packagerName) {
        return Stream.concat(NBPackage.globalOptions(), NBPackage.findPackager(packagerName).options());
    }

    public static Stream<Template> templates() {
        return NBPackage.packagers().flatMap(Packager::templates);
    }

    public static Stream<Template> templates(String packagerName) {
        return NBPackage.findPackager(packagerName).templates();
    }

    public static Optional<String> version() {
        String version = null;
        try (InputStream pomProps = NBPackage.class.getResourceAsStream("/META-INF/maven/org.apache.netbeans/nbpackage/pom.properties");){
            if (pomProps != null) {
                Properties p = new Properties();
                p.load(pomProps);
                version = p.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(version);
    }

    private static void writeOption(StringBuilder sb, Configuration conf, Option<?> option, boolean comment) {
        String value = conf.getValue(option);
        if (option.status() != Option.Status.NORMAL && (value.isBlank() || Objects.equals(value, option.defaultValue()))) {
            return;
        }
        if (comment) {
            sb.append(System.lineSeparator());
            if (option.status() == Option.Status.DEPRECATED) {
                sb.append("# DEPRECATED").append(System.lineSeparator());
            }
            option.comment().lines().forEach(l -> sb.append("# ").append((String)l).append(System.lineSeparator()));
        }
        sb.append(option.key()).append("=").append(value).append(System.lineSeparator());
    }
}

