/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.nutch.fetcher.FetchItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchItemQueue {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Text variableFetchDelayKey = new Text("_variableFetchDelay_");
    List<FetchItem> queue = Collections.synchronizedList(new LinkedList());
    AtomicInteger inProgress = new AtomicInteger();
    AtomicLong nextFetchTime = new AtomicLong();
    AtomicInteger exceptionCounter = new AtomicInteger();
    long crawlDelay;
    long minCrawlDelay;
    int maxThreads;
    Text cookie;
    boolean variableFetchDelaySet = false;
    Set<Integer> alreadyFetched;

    public FetchItemQueue(Configuration conf, int maxThreads, long crawlDelay, long minCrawlDelay) {
        this.maxThreads = maxThreads;
        this.crawlDelay = crawlDelay;
        this.minCrawlDelay = minCrawlDelay;
        if (conf.getInt("fetcher.follow.outlinks.depth", -1) > 0) {
            this.alreadyFetched = new HashSet<Integer>();
        }
        this.setEndTime(System.currentTimeMillis() - crawlDelay);
    }

    public synchronized int emptyQueue() {
        int presize = this.queue.size();
        this.queue.clear();
        return presize;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getInProgressSize() {
        return this.inProgress.get();
    }

    public int incrementExceptionCounter() {
        return this.exceptionCounter.incrementAndGet();
    }

    public void finishFetchItem(FetchItem it, boolean asap) {
        if (it != null) {
            this.inProgress.decrementAndGet();
            this.setEndTime(System.currentTimeMillis(), asap);
        }
    }

    public void addFetchItem(FetchItem it) {
        if (it == null) {
            return;
        }
        if (it.datum.getMetaData().containsKey((Object)variableFetchDelayKey)) {
            if (!this.variableFetchDelaySet) {
                this.variableFetchDelaySet = true;
                this.crawlDelay = ((LongWritable)it.datum.getMetaData().get((Object)variableFetchDelayKey)).get();
                this.minCrawlDelay = ((LongWritable)it.datum.getMetaData().get((Object)variableFetchDelayKey)).get();
                this.setEndTime(System.currentTimeMillis() - this.crawlDelay);
            }
            it.datum.getMetaData().remove((Object)variableFetchDelayKey);
        }
        this.queue.add(it);
    }

    public void addInProgressFetchItem(FetchItem it) {
        if (it == null) {
            return;
        }
        this.inProgress.incrementAndGet();
    }

    public FetchItem getFetchItem() {
        if (this.inProgress.get() >= this.maxThreads) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (this.nextFetchTime.get() > now) {
            return null;
        }
        FetchItem it = null;
        if (this.queue.size() == 0) {
            return null;
        }
        try {
            it = this.queue.remove(0);
            this.inProgress.incrementAndGet();
        }
        catch (Exception e) {
            LOG.error("Cannot remove FetchItem from queue or cannot add it to inProgress queue", (Throwable)e);
        }
        return it;
    }

    public void setCookie(Text cookie) {
        this.cookie = cookie;
    }

    public Text getCookie() {
        return this.cookie;
    }

    public synchronized void dump() {
        LOG.info("  maxThreads    = {}", (Object)this.maxThreads);
        LOG.info("  inProgress    = {}", (Object)this.inProgress.get());
        LOG.info("  crawlDelay    = {}", (Object)this.crawlDelay);
        LOG.info("  minCrawlDelay = {}", (Object)this.minCrawlDelay);
        LOG.info("  nextFetchTime = {}", (Object)this.nextFetchTime.get());
        LOG.info("  now           = {}", (Object)System.currentTimeMillis());
        for (int i = 0; i < this.queue.size(); ++i) {
            FetchItem it = this.queue.get(i);
            LOG.info("  {}. {}", (Object)i, (Object)it.url);
        }
    }

    private void setEndTime(long endTime) {
        this.setEndTime(endTime, false);
    }

    private void setEndTime(long endTime, boolean asap) {
        if (!asap) {
            this.nextFetchTime.set(endTime + (this.maxThreads > 1 ? this.minCrawlDelay : this.crawlDelay));
        } else {
            this.nextFetchTime.set(endTime);
        }
    }
}

