/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.CloseableIterator;
import org.archive.util.iterator.PeekableIterator;

public class SortedCompositeIterator<E>
implements CloseableIterator<E> {
    private static final Logger LOGGER = Logger.getLogger(SortedCompositeIterator.class.getName());
    private static final int DEFAULT_CAPACITY = 10;
    PriorityQueue<PeekableIterator<E>> q = null;

    public SortedCompositeIterator(Comparator<E> comparator) {
        this(10, comparator);
    }

    public SortedCompositeIterator(int capacity, Comparator<E> comparator) {
        this.q = new PriorityQueue<E>(capacity, new PeekableIteratorComparator<E>(comparator));
    }

    public void addAll(Collection<Iterator<E>> toAdd) {
        for (Iterator<E> e : toAdd) {
            this.addIterator(e);
        }
    }

    public void addIterator(Iterator<E> itr) {
        PeekableIterator<E> i = null;
        i = itr instanceof PeekableIterator ? (PeekableIterator<E>)itr : AbstractPeekableIterator.wrap(itr);
        if (i.hasNext()) {
            this.q.add(i);
        }
    }

    @Override
    public boolean hasNext() {
        return this.q.peek() != null;
    }

    @Override
    public E next() {
        PeekableIterator<E> i = this.q.poll();
        if (i == null) {
            throw new NoSuchElementException("Call hasNext!");
        }
        Object tmp = i.next();
        if (i.hasNext()) {
            this.q.add(i);
        } else {
            try {
                i.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("No remove");
    }

    @Override
    public void close() throws IOException {
        for (PeekableIterator<E> i : this.q) {
            try {
                i.close();
            }
            catch (IOException io) {
                LOGGER.warning(io.toString());
            }
        }
    }

    private class PeekableIteratorComparator<J>
    implements Comparator<PeekableIterator<J>> {
        private Comparator<J> comparator = null;

        public PeekableIteratorComparator(Comparator<J> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(PeekableIterator<J> o1, PeekableIterator<J> o2) {
            return this.comparator.compare(o1.peek(), o2.peek());
        }
    }
}

