/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.longpolling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.longpolling.ManyPullRequest;
import org.apache.rocketmq.broker.longpolling.PullRequest;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.exception.ConsumeQueueException;

public class PullRequestHoldService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected static final String TOPIC_QUEUEID_SEPARATOR = "@";
    protected final BrokerController brokerController;
    private final SystemClock systemClock = new SystemClock();
    protected ConcurrentMap<String, ManyPullRequest> pullRequestTable = new ConcurrentHashMap<String, ManyPullRequest>(1024);

    public PullRequestHoldService(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public void suspendPullRequest(String topic, int queueId, PullRequest pullRequest) {
        ManyPullRequest prev;
        String key = this.buildKey(topic, queueId);
        ManyPullRequest mpr = (ManyPullRequest)this.pullRequestTable.get(key);
        if (null == mpr && (prev = this.pullRequestTable.putIfAbsent(key, mpr = new ManyPullRequest())) != null) {
            mpr = prev;
        }
        pullRequest.getRequestCommand().setSuspended(true);
        mpr.addPullRequest(pullRequest);
    }

    private String buildKey(String topic, int queueId) {
        StringBuilder sb = new StringBuilder(topic.length() + 5);
        sb.append(topic);
        sb.append(TOPIC_QUEUEID_SEPARATOR);
        sb.append(queueId);
        return sb.toString();
    }

    public void run() {
        log.info("{} service started", (Object)this.getServiceName());
        while (!this.isStopped()) {
            try {
                if (this.brokerController.getBrokerConfig().isLongPollingEnable()) {
                    this.waitForRunning(5000L);
                } else {
                    this.waitForRunning(this.brokerController.getBrokerConfig().getShortPollingTimeMills());
                }
                long beginLockTimestamp = this.systemClock.now();
                this.checkHoldRequest();
                long costTime = this.systemClock.now() - beginLockTimestamp;
                if (costTime <= 5000L) continue;
                log.warn("PullRequestHoldService: check hold pull request cost {}ms", (Object)costTime);
            }
            catch (Throwable e) {
                log.warn(this.getServiceName() + " service has exception. ", e);
            }
        }
        log.info("{} service end", (Object)this.getServiceName());
    }

    public String getServiceName() {
        if (this.brokerController != null && this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getIdentifier() + PullRequestHoldService.class.getSimpleName();
        }
        return PullRequestHoldService.class.getSimpleName();
    }

    protected void checkHoldRequest() {
        for (String key : this.pullRequestTable.keySet()) {
            String[] kArray = key.split(TOPIC_QUEUEID_SEPARATOR);
            if (2 != kArray.length) continue;
            String topic = kArray[0];
            int queueId = Integer.parseInt(kArray[1]);
            try {
                long offset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
                this.notifyMessageArriving(topic, queueId, offset);
            }
            catch (Throwable e) {
                log.error("PullRequestHoldService: failed to check hold request failed, topic={}, queueId={}", new Object[]{topic, queueId, e});
            }
        }
    }

    public void notifyMessageArriving(String topic, int queueId, long maxOffset) {
        this.notifyMessageArriving(topic, queueId, maxOffset, null, 0L, null, null);
    }

    public void notifyMessageArriving(String topic, int queueId, long maxOffset, Long tagsCode, long msgStoreTime, byte[] filterBitMap, Map<String, String> properties) {
        List<PullRequest> requestList;
        String key = this.buildKey(topic, queueId);
        ManyPullRequest mpr = (ManyPullRequest)this.pullRequestTable.get(key);
        if (mpr != null && (requestList = mpr.cloneListAndClear()) != null) {
            ArrayList<PullRequest> replayList = new ArrayList<PullRequest>();
            Iterator<PullRequest> iterator = requestList.iterator();
            while (iterator.hasNext()) {
                long newestOffset = maxOffset;
                PullRequest request = iterator.next();
                if (newestOffset <= request.getPullFromThisOffset()) {
                    try {
                        newestOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
                    }
                    catch (ConsumeQueueException e) {
                        log.error("Failed tp get max offset in queue", (Throwable)e);
                        continue;
                    }
                }
                if (newestOffset > request.getPullFromThisOffset()) {
                    boolean match = request.getMessageFilter().isMatchedByConsumeQueue(tagsCode, new ConsumeQueueExt.CqExtUnit(tagsCode, msgStoreTime, filterBitMap));
                    if (match && properties != null) {
                        match = request.getMessageFilter().isMatchedByCommitLog(null, properties);
                    }
                    if (match) {
                        try {
                            this.brokerController.getPullMessageProcessor().executeRequestWhenWakeup(request.getClientChannel(), request.getRequestCommand());
                        }
                        catch (Throwable e) {
                            log.error("PullRequestHoldService#notifyMessageArriving: failed to execute request when message matched, topic={}, queueId={}", new Object[]{topic, queueId, e});
                        }
                        continue;
                    }
                }
                if (System.currentTimeMillis() >= request.getSuspendTimestamp() + request.getTimeoutMillis()) {
                    try {
                        this.brokerController.getPullMessageProcessor().executeRequestWhenWakeup(request.getClientChannel(), request.getRequestCommand());
                    }
                    catch (Throwable e) {
                        log.error("PullRequestHoldService#notifyMessageArriving: failed to execute request when time's up, topic={}, queueId={}", new Object[]{topic, queueId, e});
                    }
                    continue;
                }
                replayList.add(request);
            }
            if (!replayList.isEmpty()) {
                mpr.addPullRequest(replayList);
            }
        }
    }

    public void notifyMasterOnline() {
        for (ManyPullRequest mpr : this.pullRequestTable.values()) {
            if (mpr == null || mpr.isEmpty()) continue;
            for (PullRequest request : mpr.cloneListAndClear()) {
                try {
                    log.info("notify master online, wakeup {} {}", (Object)request.getClientChannel(), (Object)request.getRequestCommand());
                    this.brokerController.getPullMessageProcessor().executeRequestWhenWakeup(request.getClientChannel(), request.getRequestCommand());
                }
                catch (Throwable e) {
                    log.error("execute request when master online failed.", e);
                }
            }
        }
    }
}

