/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.metadata;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javax.measure.Unit;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.LogHandler;
import org.apache.sis.gui.metadata.MetadataSummary;
import org.apache.sis.gui.metadata.Section;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicDescription;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;

final class IdentificationInfo
extends Section<Identification> {
    private static final double MAP_WIDTH = 360.0;
    private static final double MAP_HEIGHT = 180.0;
    private static final double MIN_RECT_SIZE = 6.0;
    private final Label title = new Label();
    private Canvas extentOnMap;
    private boolean isWorld;
    private boolean mapWasVisible;
    private Task<?> aggregateWalker;

    IdentificationInfo(MetadataSummary owner) {
        super(owner);
        this.title.setFont(Font.font(null, (FontWeight)FontWeight.BOLD, (double)15.0));
        this.add((Node)this.title, 0, 0, 2, 1);
        this.extentOnMap = new Canvas();
        this.add((Node)this.extentOnMap, 0, 0, 2, 1);
        IdentificationInfo.setHalignment((Node)this.extentOnMap, (HPos)HPos.CENTER);
        this.finished();
    }

    private void clearWorldMap() {
        if (!this.isWorldMapEmpty()) {
            int p = this.linesStartIndex() - 1;
            assert (this.getChildren().get(p) == this.extentOnMap);
            this.extentOnMap = new Canvas();
            this.getChildren().set(p, (Object)this.extentOnMap);
            IdentificationInfo.setColumnSpan((Node)this.extentOnMap, (Integer)2);
            IdentificationInfo.setHalignment((Node)this.extentOnMap, (HPos)HPos.CENTER);
        }
    }

    private boolean isWorldMapEmpty() {
        return this.extentOnMap.getWidth() == 0.0 && this.extentOnMap.getHeight() == 0.0;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isWorldMapEmpty();
    }

    final void completeMissingGeographicBounds(final Aggregate resource) {
        if (!this.isWorld && this.isWorldMapEmpty() && !super.isEmpty() && this.numPages() == 1) {
            if (this.mapWasVisible) {
                this.drawMapBackground();
            }
            this.aggregateWalker = new Task<Set<GeographicBoundingBox>>(this){
                final /* synthetic */ IdentificationInfo this$0;
                {
                    this.this$0 = this$0;
                }

                protected Set<GeographicBoundingBox> call() throws DataStoreException {
                    LinkedHashSet<GeographicBoundingBox> boxes = new LinkedHashSet<GeographicBoundingBox>();
                    try {
                        for (Resource child : resource.components()) {
                            Metadata metadata = child.getMetadata();
                            if (!this.isCancelled()) {
                                if (metadata == null) continue;
                                for (Identification id : Containers.nonNull((Collection)metadata.getIdentificationInfo())) {
                                    if (!(id instanceof DataIdentification)) continue;
                                    DataIdentification did = (DataIdentification)id;
                                    for (Extent extent : did.getExtents()) {
                                        GeographicBoundingBox b = Extents.getGeographicBoundingBox((Extent)extent);
                                        if (b == null) continue;
                                        boxes.add(b);
                                    }
                                }
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BackingStoreException e) {
                        throw (DataStoreException)((Object)e.unwrapOrRethrow(DataStoreException.class));
                    }
                    return boxes;
                }

                protected void succeeded() {
                    this.this$0.aggregateWalker = null;
                    this.this$0.drawOnMap((Set)this.getValue());
                }

                protected void failed() {
                    this.this$0.aggregateWalker = null;
                    this.this$0.owner.setError(this.getException());
                }
            };
            BackgroundThreads.execute((Runnable)this.aggregateWalker);
        }
    }

    @Override
    void setInformation(Metadata metadata) {
        Collection info;
        if (this.aggregateWalker != null) {
            this.aggregateWalker.cancel(false);
            this.aggregateWalker = null;
        }
        if (metadata == null) {
            this.clearWorldMap();
            info = null;
        } else {
            info = metadata.getIdentificationInfo();
        }
        this.setInformation(Containers.nonNull((Collection)info), Identification[]::new);
    }

    @Override
    void buildContent(Identification info) {
        DataIdentification dataInfo;
        this.mapWasVisible = !this.isWorldMapEmpty();
        this.isWorld = false;
        this.clearWorldMap();
        Object text = null;
        Citation citation = info.getCitation();
        if (citation != null && (text = this.owner.string(citation.getTitle())) == null) {
            text = Citations.getIdentifier((Citation)citation);
        }
        if (text == null) {
            text = this.owner.vocabulary.getString((short)210);
        } else if (CharSequences.isUnicodeIdentifier(text)) {
            text = CharSequences.camelCaseToSentence((CharSequence)text).toString();
        }
        this.title.setText((String)text);
        if (citation != null) {
            StringJoiner buffer = new StringJoiner(", ");
            for (Identifier id : citation.getIdentifiers()) {
                buffer.add(IdentifiedObjects.toString((Identifier)id));
            }
            if (buffer.length() != 0) {
                this.addLine((short)100, buffer.toString());
            }
        }
        short label = 1;
        text = this.owner.string(info.getAbstract());
        if (text == null) {
            label = 164;
            text = this.owner.string(info.getPurpose());
            if (text == null) {
                for (Object c : Containers.nonNull((Collection)info.getCredits())) {
                    text = c;
                    if (text == null) continue;
                    label = 42;
                    break;
                }
            }
        }
        this.addLine(label, (String)text);
        DataIdentification dataIdentification = dataInfo = info instanceof DataIdentification ? (DataIdentification)info : null;
        if (dataInfo != null) {
            this.addLine((short)198, this.owner.string(Containers.nonNull((Collection)dataInfo.getTopicCategories())));
            this.addLine((short)204, this.owner.string(Containers.nonNull((Collection)dataInfo.getSpatialRepresentationTypes())));
        }
        for (Object format : Containers.nonNull((Collection)info.getResourceFormats())) {
            text = this.owner.string(format.getSpecification());
            if (text == null) continue;
            this.addLine((short)85, (String)text);
            break;
        }
        if (citation != null) {
            Date date = null;
            label = 52;
            for (CitationDate c : Containers.nonNull((Collection)citation.getDates())) {
                boolean isCreation;
                Date cd = c.getDate();
                if (cd == null) continue;
                DateType type = c.getDateType();
                if (type == DateType.PUBLICATION || type == DateType.valueOf((String)"RELEASED")) {
                    label = 163;
                    date = cd;
                    break;
                }
                boolean bl = isCreation = type == DateType.CREATION;
                if (date != null && !isCreation) continue;
                label = isCreation ? (short)41 : 52;
                date = cd;
            }
            this.addLine(label, this.owner.format(date));
        }
        text = null;
        Identifier identifier = null;
        Range timeRange = null;
        MeasurementRange heights = null;
        for (Extent extent : Containers.nonNull((Collection)(dataInfo != null ? dataInfo.getExtents() : null))) {
            Range t;
            if (extent == null) continue;
            if (text == null) {
                text = this.owner.string(extent.getDescription());
            }
            for (GeographicExtent ge : Containers.nonNull((Collection)extent.getGeographicElements())) {
                if (identifier == null && ge instanceof GeographicDescription) {
                    identifier = ((GeographicDescription)ge).getGeographicIdentifier();
                }
                if (this.isWorld || !(ge instanceof GeographicBoundingBox)) continue;
                this.isWorld = this.drawOnMap((GeographicBoundingBox)ge);
            }
            try {
                MeasurementRange v = Extents.getVerticalRange((Extent)extent);
                if (v != null) {
                    heights = heights != null ? heights.union((Range)v) : v;
                }
            }
            catch (InvalidMetadataException e) {
                Logging.recoverableException((Logger)LogHandler.LOGGER, MetadataSummary.class, (String)"setMetadata", (Throwable)e);
            }
            if ((t = Extents.getTimeRange((Extent)extent)) == null) continue;
            timeRange = timeRange != null ? timeRange.union(t) : t;
        }
        if (text == null) {
            text = IdentifiedObjects.toString(identifier);
        }
        if (this.isWorld) {
            this.clearWorldMap();
            if (text == null) {
                text = this.owner.vocabulary.getString((short)225);
            }
        }
        this.addLine((short)81, (String)text);
        if (timeRange != null) {
            label = 186;
            Date t = (Date)timeRange.getMinValue();
            if (t == null) {
                t = (Date)timeRange.getMaxValue();
                label = 75;
            }
            this.addLine(label, this.owner.format(t));
        }
        if (heights != null) {
            Double min = (Double)heights.getMinValue();
            Double max = (Double)heights.getMaxValue();
            if (min != null || max != null) {
                Unit unit;
                StringBuffer b = new StringBuffer(20);
                if (min != null && max != null && !min.equals(max)) {
                    this.owner.formats.formatPair(min, " \u2026 ", max, b);
                } else {
                    this.owner.format(min != null ? min : max, b);
                }
                if (heights instanceof MeasurementRange && (unit = heights.unit()) != null) {
                    this.owner.format(unit, b.append(' '));
                }
                this.addLine((short)98, b.toString());
            }
        }
        IdentificationInfo.setRowIndex((Node)this.extentOnMap, (Integer)this.nextRowIndex());
    }

    private void drawOnMap(Set<GeographicBoundingBox> boxes) {
        if (boxes.isEmpty()) {
            this.clearWorldMap();
            return;
        }
        for (GeographicBoundingBox box : boxes) {
            this.isWorld = this.drawOnMap(box);
            if (!this.isWorld) continue;
            this.clearWorldMap();
            return;
        }
    }

    private boolean drawOnMap(GeographicBoundingBox bbox) {
        double west;
        double north = Latitude.clamp((double)bbox.getNorthBoundLatitude());
        double south = Latitude.clamp((double)bbox.getSouthBoundLatitude());
        double east = bbox.getEastBoundLongitude();
        if (Math.abs(east - (west = bbox.getWestBoundLongitude())) >= 359.9999998200144) {
            if (north >= 89.9999999100072 && south <= -89.9999999100072) {
                return true;
            }
            west = -180.0;
            east = 180.0;
        } else {
            if (west != 180.0) {
                west = Longitude.normalize((double)west);
            }
            if (east != 180.0) {
                east = Longitude.normalize((double)east);
            }
            if (east < west) {
                east += 360.0;
            }
        }
        if (north >= south && Double.isFinite(east) && Double.isFinite(west)) {
            double wi;
            boolean crossAntimeridian;
            double x = 180.0 + west;
            double y = 90.0 - north;
            double w = east - west;
            double h = north - south;
            if (w < 6.0) {
                x -= (6.0 - w) / 2.0;
                w = 6.0;
            }
            if (h < 6.0) {
                y -= (6.0 - h) / 2.0;
                h = 6.0;
            }
            boolean bl = crossAntimeridian = (w -= (wi = Math.min(w, 360.0 - x))) > 0.0;
            if (this.isWorldMapEmpty()) {
                this.drawMapBackground();
            }
            GraphicsContext gc = this.extentOnMap.getGraphicsContext2D();
            gc.setStroke((Paint)Color.DARKBLUE);
            gc.setGlobalAlpha(0.1);
            gc.fillRect(x, y, wi, h);
            if (crossAntimeridian) {
                gc.fillRect(0.0, y, w, h);
            }
            gc.setGlobalAlpha(1.0);
            if (!crossAntimeridian) {
                gc.strokeRect(x, y, wi, h);
            } else {
                double xw = x + wi;
                double yh = y + h;
                gc.strokePolyline(new double[]{xw, x, x, xw}, new double[]{y, y, yh, yh}, 4);
                gc.strokePolyline(new double[]{0.0, w, w, 0.0}, new double[]{y, y, yh, yh}, 4);
            }
        }
        return false;
    }

    private boolean drawMapBackground() {
        Image image = MetadataSummary.getWorldMap();
        if (image == null) {
            return false;
        }
        this.extentOnMap.setWidth(image.getWidth());
        this.extentOnMap.setHeight(image.getHeight());
        this.extentOnMap.getGraphicsContext2D().drawImage(image, 0.0, 0.0);
        return true;
    }
}

