/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.util.iso.Names;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.ScopedName;

public final class AttributeConvention {
    private static final LocalName SCOPE = Names.createLocalName((CharSequence)"Apache", null, (CharSequence)"sis");
    public static final ScopedName IDENTIFIER_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"identifier");
    public static final ScopedName GEOMETRY_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"geometry");
    public static final ScopedName ENVELOPE_PROPERTY = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"envelope");
    public static final ScopedName CRS_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"crs");
    public static final ScopedName UNIT_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"unit");
    public static final ScopedName MAXIMAL_LENGTH_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"maximalLength");
    public static final GenericName VALID_VALUES_CHARACTERISTIC = Names.createScopedName((GenericName)SCOPE, null, (CharSequence)"validValues");
    public static final String IDENTIFIER = "sis:identifier";
    public static final String GEOMETRY = "sis:geometry";
    public static final String ENVELOPE = "sis:envelope";
    public static final String CRS = "sis:crs";
    public static final String UNIT = "sis:unit";
    public static final String MAXIMAL_LENGTH = "sis:maximalLength";
    public static final String DISAMBIGUATION_SEQUENTIAL_NUMBER_PREFIX = " #";

    private AttributeConvention() {
    }

    public static boolean contains(GenericName name) {
        while (name instanceof ScopedName) {
            if (SCOPE.equals((Object)((ScopedName)name).path())) {
                return true;
            }
            name = ((ScopedName)name).tail();
        }
        return false;
    }

    public static boolean isGeometryAttribute(AbstractIdentifiedType type) {
        Optional<DefaultAttributeType<?>> at = Features.toAttribute(type);
        return at.isPresent() && Geometries.isKnownType(at.get().getValueClass());
    }

    public static boolean characterizedByCRS(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, CRS, CoordinateReferenceSystem.class);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(AbstractFeature feature, String property) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(feature, property, CRS);
    }

    public static CoordinateReferenceSystem getCRSCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType attribute) {
        return (CoordinateReferenceSystem)AttributeConvention.getCharacteristic(feature, attribute, CRS);
    }

    public static boolean characterizedByMaximalLength(AbstractIdentifiedType type) {
        return AttributeConvention.hasCharacteristic(type, MAXIMAL_LENGTH, Integer.class);
    }

    public static Integer getMaximalLengthCharacteristic(AbstractFeature feature, String property) {
        return (Integer)AttributeConvention.getCharacteristic(feature, property, MAXIMAL_LENGTH);
    }

    public static Integer getMaximalLengthCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType attribute) {
        return (Integer)AttributeConvention.getCharacteristic(feature, attribute, MAXIMAL_LENGTH);
    }

    private static boolean hasCharacteristic(AbstractIdentifiedType type, String name, Class<?> valueClass) {
        DefaultAttributeType<?> ct;
        Optional<DefaultAttributeType<?>> at = Features.toAttribute(type);
        if (at.isPresent() && (ct = at.get().characteristics().get(name)) != null) {
            return valueClass.isAssignableFrom(ct.getValueClass());
        }
        return false;
    }

    private static Object getCharacteristic(AbstractFeature feature, String property, String characteristic) {
        return feature.getCharacteristicValue(property, characteristic).orElse(null);
    }

    private static Object getCharacteristic(DefaultFeatureType feature, AbstractIdentifiedType property, String characteristic) {
        DefaultAttributeType<?> type;
        Optional<String> referent = Features.getLinkTarget(property);
        if (referent.isPresent() && feature != null) {
            property = feature.getProperty(referent.get());
        }
        if (property instanceof DefaultAttributeType && (type = ((DefaultAttributeType)property).characteristics().get(characteristic)) != null) {
            return type.getDefaultValue();
        }
        return null;
    }
}

