/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.OnlineResourceAdapter;
import org.apache.sis.metadata.iso.URIStringAdapter;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.citation.Citation;

@XmlType(name="MD_ApplicationSchemaInformation_Type", namespace="http://standards.iso.org/iso/19115/-3/mas/1.0", propOrder={"name", "schemaLanguage", "constraintLanguage", "schemaAscii", "graphicsFile", "softwareDevelopmentFile", "softwareDevelopmentFileFormat"})
@XmlRootElement(name="MD_ApplicationSchemaInformation", namespace="http://standards.iso.org/iso/19115/-3/mas/1.0")
public class DefaultApplicationSchemaInformation
extends ISOMetadata
implements ApplicationSchemaInformation {
    private static final long serialVersionUID = -884081423040392985L;
    private Citation name;
    private String schemaLanguage;
    private String constraintLanguage;
    private URI schemaAscii;
    private URI graphicsFile;
    private URI softwareDevelopmentFile;
    private String softwareDevelopmentFileFormat;

    public DefaultApplicationSchemaInformation() {
    }

    public DefaultApplicationSchemaInformation(Citation name, String schemaLanguage, String constraintLanguage) {
        this.name = name;
        this.schemaLanguage = schemaLanguage;
        this.constraintLanguage = constraintLanguage;
    }

    public DefaultApplicationSchemaInformation(ApplicationSchemaInformation object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.schemaLanguage = object.getSchemaLanguage();
            this.constraintLanguage = object.getConstraintLanguage();
            this.schemaAscii = object.getSchemaAscii();
            this.graphicsFile = object.getGraphicsFile();
            this.softwareDevelopmentFile = object.getSoftwareDevelopmentFile();
            this.softwareDevelopmentFileFormat = object.getSoftwareDevelopmentFileFormat();
        }
    }

    public static DefaultApplicationSchemaInformation castOrCopy(ApplicationSchemaInformation object) {
        if (object == null || object instanceof DefaultApplicationSchemaInformation) {
            return (DefaultApplicationSchemaInformation)object;
        }
        return new DefaultApplicationSchemaInformation(object);
    }

    @XmlElement(name="name", required=true)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="schemaLanguage", required=true)
    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String newValue) {
        this.checkWritePermission(this.schemaLanguage);
        this.schemaLanguage = newValue;
    }

    @XmlElement(name="constraintLanguage", required=true)
    public String getConstraintLanguage() {
        return this.constraintLanguage;
    }

    public void setConstraintLanguage(String newValue) {
        this.checkWritePermission(this.constraintLanguage);
        this.constraintLanguage = newValue;
    }

    @XmlElement(name="schemaAscii")
    @XmlJavaTypeAdapter(value=URIStringAdapter.class)
    public URI getSchemaAscii() {
        return this.schemaAscii;
    }

    public void setSchemaAscii(URI newValue) {
        this.checkWritePermission(this.schemaAscii);
        this.schemaAscii = newValue;
    }

    @XmlElement(name="graphicsFile")
    @XmlJavaTypeAdapter(value=OnlineResourceAdapter.class)
    public URI getGraphicsFile() {
        return this.graphicsFile;
    }

    public void setGraphicsFile(URI newValue) {
        this.checkWritePermission(this.graphicsFile);
        this.graphicsFile = newValue;
    }

    @XmlElement(name="softwareDevelopmentFile")
    @XmlJavaTypeAdapter(value=OnlineResourceAdapter.class)
    public URI getSoftwareDevelopmentFile() {
        return this.softwareDevelopmentFile;
    }

    public void setSoftwareDevelopmentFile(URI newValue) {
        this.checkWritePermission(this.softwareDevelopmentFile);
        this.softwareDevelopmentFile = newValue;
    }

    @XmlElement(name="softwareDevelopmentFileFormat")
    public String getSoftwareDevelopmentFileFormat() {
        return this.softwareDevelopmentFileFormat;
    }

    public void setSoftwareDevelopmentFileFormat(String newValue) {
        this.checkWritePermission(this.softwareDevelopmentFileFormat);
        this.softwareDevelopmentFileFormat = newValue;
    }
}

