/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.internal;

import java.text.CharacterIterator;
import org.apache.sis.util.ArgumentChecks;

public class SimpleCharacterIterator
implements CharacterIterator,
CharSequence {
    protected final CharSequence text;
    protected static final int lower = 0;
    protected int upper;
    private int index;

    public SimpleCharacterIterator(CharSequence text) {
        this.text = text;
        this.upper = text.length();
    }

    @Override
    public final char first() {
        if (this.upper == 0) {
            return '\uffff';
        }
        this.index = 0;
        return this.text.charAt(0);
    }

    @Override
    public final char last() {
        if (this.upper == 0) {
            return '\uffff';
        }
        this.index = this.upper - 1;
        return this.text.charAt(this.index);
    }

    @Override
    public final char current() {
        return this.index != this.upper ? this.text.charAt(this.index) : (char)'\uffff';
    }

    @Override
    public final char next() {
        if (++this.index < this.upper) {
            return this.text.charAt(this.index);
        }
        this.index = this.upper;
        return '\uffff';
    }

    @Override
    public final char previous() {
        if (--this.index >= 0) {
            return this.text.charAt(this.index);
        }
        this.index = 0;
        return '\uffff';
    }

    @Override
    public final char charAt(int index) {
        return this.text.charAt(index);
    }

    @Override
    public final char setIndex(int position) {
        ArgumentChecks.ensureBetween("position", 0, this.upper, position);
        this.index = position;
        return this.index != this.upper ? this.text.charAt(position) : (char)'\uffff';
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getBeginIndex() {
        return 0;
    }

    @Override
    public final int getEndIndex() {
        return this.upper;
    }

    @Override
    public final int length() {
        return this.upper - 0;
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.text.subSequence(start, end);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final String toString() {
        return this.text.subSequence(0, this.upper).toString();
    }
}

