/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Map;
import org.apache.sis.image.internal.shared.BatchComputedImage;
import org.apache.sis.storage.base.TiledGridCoverage;

final class TiledDeferredImage
extends BatchComputedImage {
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    private final TiledGridCoverage.TileIterator iterator;

    TiledDeferredImage(int[] imageSize, int[] tileLower, Map<String, Object> properties, TiledGridCoverage.TileIterator iterator) {
        super(iterator.getCoverage().model, properties, new RenderedImage[0]);
        this.width = imageSize[0];
        this.height = imageSize[1];
        this.minTileX = tileLower[0];
        this.minTileY = tileLower[1];
        this.iterator = iterator;
    }

    public ColorModel getColorModel() {
        return this.iterator.getCoverage().colors;
    }

    public final int getMinX() {
        return this.iterator.getTileOrigin(0);
    }

    public final int getMinY() {
        return this.iterator.getTileOrigin(1);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getMinTileX() {
        return this.minTileX;
    }

    public final int getMinTileY() {
        return this.minTileY;
    }

    protected Raster[] computeTiles(Rectangle tiles) throws Exception {
        TiledGridCoverage.TileIterator aoi = this.iterator.subset(new int[]{tiles.x, tiles.y}, new int[]{Math.addExact(tiles.x, tiles.width), Math.addExact(tiles.y, tiles.height)});
        return aoi.getCoverage().readTiles(aoi);
    }
}

