/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.util.List;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderFileVaultXmlTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    protected String path;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.path = this.context.uniqueRoot().content();
        try {
            NodeTypeDefinitionScanner.get().register((Session)this.context.resourceResolver().adaptTo(Session.class), List.of("SLING-INF/nodetypes/app.cnd"), this.getResourceResolverType().getNodeTypeMode());
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to register namespaces.", ex);
        }
        this.context.load().fileVaultXml("src/test/resources/xml-jcr-import-samples/content/samples/en/.content.xml", this.path + "/sample/en");
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testPageResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en");
        Assert.assertEquals((Object)"app:Page", (Object)resource.getResourceType());
    }

    @Test
    public void testPageJcrPrimaryType() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en");
        this.assertPrimaryNodeType(resource, "app:Page");
    }

    @Test
    public void testPageContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        Assert.assertEquals((Object)"samples/sample-app/components/content/page/homepage", (Object)resource.getResourceType());
    }

    @Test
    public void testPageContentJcrPrimaryType() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        this.assertPrimaryNodeType(resource, "app:PageContent");
    }

    @Test
    public void testPageContentMixinTypes() throws RepositoryException {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        this.assertMixinTypes(resource, "app:TestMixin");
    }

    @Test
    public void testPageContentProperties() {
        Resource resource = this.context.resourceResolver().getResource(this.path + "/sample/en/jcr:content");
        ValueMap props = ResourceUtil.getValueMap((Resource)resource);
        Assert.assertEquals((Object)"HOME", (Object)props.get("navTitle", String.class));
        Assert.assertEquals((Object)true, (Object)props.get("includeAside", Boolean.class));
    }

    private void assertPrimaryNodeType(Resource resource, String nodeType) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            Assert.assertEquals((Object)nodeType, (Object)node.getPrimaryNodeType().getName());
        } else {
            ValueMap props = ResourceUtil.getValueMap((Resource)resource);
            Assert.assertEquals((Object)nodeType, (Object)props.get((Object)"jcr:primaryType"));
        }
    }

    private void assertMixinTypes(Resource resource, String ... mixinTypes) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            Assert.assertArrayEquals((Object[])mixinTypes, (Object[])Stream.of(node.getMixinNodeTypes()).map(NodeTypeDefinition::getName).toArray(String[]::new));
        } else {
            ValueMap props = ResourceUtil.getValueMap((Resource)resource);
            Assert.assertArrayEquals((Object[])mixinTypes, (Object[])((Object[])props.get("jcr:mixinTypes", String[].class)));
        }
    }
}

