/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.widget.progressbar;

import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.KendoUIBehavior;
import com.googlecode.wicket.kendo.ui.widget.progressbar.IProgressBarListener;
import com.googlecode.wicket.kendo.ui.widget.progressbar.ProgressBarBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class ProgressBar
extends JQueryGenericContainer<Integer>
implements IProgressBarListener {
    private static final long serialVersionUID = 1L;
    private static final int MIN = 0;
    private static final int MAX = 100;
    private boolean valueChanged = false;
    protected final Options options;

    public ProgressBar(String id) {
        this(id, new Options());
    }

    public ProgressBar(String id, Options options) {
        super(id);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public ProgressBar(String id, IModel<Integer> model) {
        this(id, model, new Options());
    }

    public ProgressBar(String id, IModel<Integer> model, Options options) {
        super(id, model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    public int getMin() {
        Integer min = (Integer)this.options.get("min");
        return min != null ? min : 0;
    }

    public int getMax() {
        Integer max = (Integer)this.options.get("max");
        return max != null ? max : 100;
    }

    public JQueryGenericContainer<Integer> setModelObject(Integer value) {
        Integer v = (Integer)Args.notNull((Object)value, (String)"value");
        if (v < this.getMin()) {
            v = this.getMin();
        } else if (v > this.getMax()) {
            v = this.getMax();
        }
        return (JQueryGenericContainer)super.setModelObject((Object)v);
    }

    public String widget() {
        return KendoUIBehavior.widget((Component)this, "kendoProgressBar");
    }

    public void forward(IPartialPageRequestHandler handler) {
        this.forward(handler, 1);
    }

    public final void forward(IPartialPageRequestHandler handler, int step) {
        this.setModelObject((Integer)this.getModelObject() + step);
        this.refresh(handler);
    }

    public final void backward(IPartialPageRequestHandler handler) {
        this.backward(handler, 1);
    }

    public final void backward(IPartialPageRequestHandler handler, int step) {
        this.setModelObject((Integer)this.getModelObject() - step);
        this.refresh(handler);
    }

    public final void refresh(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)String.format("%s.value(%d);", this.widget(), this.getModelObject()));
        if (this.valueChanged) {
            this.valueChanged = false;
            this.onValueChanged(handler);
            if ((Integer)this.getModelObject() >= this.getMax()) {
                this.onComplete(handler);
            }
        }
    }

    protected void onModelChanged() {
        this.valueChanged = true;
    }

    public void onValueChanged(IPartialPageRequestHandler handler) {
    }

    @Override
    public void onComplete(IPartialPageRequestHandler handler) {
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new ProgressBarBehavior(selector, this.options);
    }
}

