/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

@Order(value=-2147483648)
public class OidcGroovyJsonWebKeystoreGeneratorService
implements OidcJsonWebKeystoreGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcGroovyJsonWebKeystoreGeneratorService.class);
    private final WatchableGroovyScriptResource watchableScript;

    public OidcGroovyJsonWebKeystoreGeneratorService(Resource watchableScript) {
        this.watchableScript = new WatchableGroovyScriptResource(watchableScript);
    }

    @Override
    public Optional<Resource> find() {
        Object[] args = new Object[]{LOGGER};
        JsonWebKeySet result = (JsonWebKeySet)this.watchableScript.execute("find", JsonWebKeySet.class, args);
        LOGGER.debug("Received JWKS resource from [{}] as [{}]", (Object)this.watchableScript, (Object)result);
        return result != null ? Optional.of(OidcJsonWebKeystoreGeneratorService.toResource(result)) : Optional.empty();
    }

    @Override
    public Resource generate() {
        Object[] args = new Object[]{LOGGER};
        String result = (String)this.watchableScript.execute(args, String.class);
        LOGGER.debug("Received payload result from [{}] as [{}]", (Object)this.watchableScript, (Object)result);
        return new ByteArrayResource(result.getBytes(StandardCharsets.UTF_8), "OIDC JWKS");
    }

    @Override
    public JsonWebKeySet store(JsonWebKeySet jsonWebKeySet) throws Exception {
        Object[] args = new Object[]{jsonWebKeySet, LOGGER};
        JsonWebKeySet result = (JsonWebKeySet)this.watchableScript.execute("store", JsonWebKeySet.class, args);
        LOGGER.debug("Received payload result from [{}] as [{}]", (Object)this.watchableScript, (Object)result);
        return result;
    }
}

