/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.collection;

import java.util.function.BinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollectionSupport {
    private static Logger log = LoggerFactory.getLogger(CollectionSupport.class);

    private CollectionSupport() {
    }

    public static <T> BinaryOperator<T> warningMergeFunction(final String what, final boolean takeFirst) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T current, T lookingAt) {
                log.warn("Duplicate detected building {}", (Object)what);
                log.debug("Values provided are {} and {} taking {}", new Object[]{current, lookingAt, takeFirst ? "first" : "last"});
                return takeFirst ? current : lookingAt;
            }
        };
    }
}

